/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mr.proto;

import com.splunk.mr.input.BaseSplunkRecordReader;
import com.splunk.mr.input.VixInputSplit;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.file.tfile.TFile;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.log4j.Logger;

public class YarnLogsRecordReader
extends BaseSplunkRecordReader {
    private static Logger gLogger = Logger.getLogger(YarnLogsRecordReader.class);
    private static Pattern FILE_PATTERN = Pattern.compile("^/tmp/logs/");
    private static String CONTAINER_KEY_PREFIX = "container_";
    protected TFile.Reader _reader = null;
    protected TFile.Reader.Scanner _scanner = null;
    private long _start = 0L;
    private long _end = 0L;
    private FSDataInputStream _fileIn = null;
    private DataInputStream _currentVal = null;
    private String _containerId = null;
    private Path _file = null;
    Text _val = new Text();
    String _logFile = null;
    int _cvRemain = 0;
    byte[] _buf = new byte[4096];
    boolean _firstLogFileRead = false;
    boolean _first = true;

    @Override
    public void vixInitialize(VixInputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        Configuration conf = context.getConfiguration();
        this._start = split.getStart();
        this._end = this._start + split.getLength();
        this._file = split.getPath();
        FileSystem fs = this._file.getFileSystem(conf);
        this._fileIn = fs.open(this._file);
        this._reader = new TFile.Reader(this._fileIn, fs.getFileStatus(this._file).getLen(), conf);
        TFile.Reader.Scanner headerScanner = this._reader.createScanner();
        while (!headerScanner.atEnd()) {
            TFile.Reader.Scanner.Entry entry = headerScanner.entry();
            String key = entry.getKeyStream().readUTF();
            DataInputStream vin = headerScanner.entry().getValueStream();
            if (key.equals("VERSION")) {
                split.setHeaderField("yarnlog.VERSION", String.valueOf(vin.readInt()));
            } else if (key.equals("APPLICATION_OWNER")) {
                split.setHeaderField("yarnlog.APPLICATION_OWNER", vin.readUTF());
            } else {
                if (!key.equals("APPLICATION_ACL")) break;
                try {
                    while (true) {
                        split.setHeaderField("yarnlog.APPLICATION_ACL." + vin.readUTF(), vin.readUTF());
                    }
                }
                catch (EOFException e) {
                    // empty catch block
                }
            }
            headerScanner.advance();
        }
        headerScanner.close();
        this._scanner = this._reader.createScannerByByteRange(this._start, split.getLength());
    }

    private void readNextLogFileHeader() throws IOException {
        do {
            this._logFile = this._currentVal.readUTF();
            this._cvRemain = Integer.parseInt(this._currentVal.readUTF());
            this._firstLogFileRead = true;
            gLogger.info((Object)String.format("found containerId=%s, logFile=%s, length=%d", this._containerId, this._logFile, this._cvRemain));
        } while (this._cvRemain == 0);
    }

    public boolean nextKeyValue() throws IOException, InterruptedException {
        if (this._scanner.atEnd()) {
            return false;
        }
        if (this._currentVal != null) {
            return true;
        }
        if (!this._first) {
            this._scanner.advance();
        }
        this._first = false;
        while (!this._scanner.atEnd() && !this._scanner.entry().getKeyStream().readUTF().startsWith(CONTAINER_KEY_PREFIX)) {
            this._scanner.advance();
        }
        if (this._scanner.atEnd()) {
            return false;
        }
        this._containerId = this._scanner.entry().getKeyStream().readUTF();
        this._currentVal = this._scanner.entry().getValueStream();
        try {
            this.readNextLogFileHeader();
        }
        catch (EOFException ex) {
            this._scanner.seekToEnd();
        }
        return true;
    }

    @Override
    public boolean appendNewLine() {
        return false;
    }

    @Override
    public boolean needsNewHeader(Map<String, Object> header) {
        if (this._firstLogFileRead) {
            header.put("field.container_id", this._containerId);
            header.put("field.logfile", this._logFile);
        }
        return this._firstLogFileRead;
    }

    public Text getCurrentKey() throws IOException, InterruptedException {
        return null;
    }

    public Text getCurrentValue() throws IOException, InterruptedException {
        if (this._currentVal == null) {
            return null;
        }
        if (this._cvRemain > 0) {
            int toRead = Math.min(this._buf.length, this._cvRemain);
            int read = this._currentVal.read(this._buf, 0, toRead);
            this._val.set(this._buf, 0, read);
            this._cvRemain -= read;
        } else {
            this._val.set(new byte[0]);
        }
        if (this._cvRemain == 0) {
            try {
                this.readNextLogFileHeader();
            }
            catch (IOException e) {
                IOUtils.closeQuietly((InputStream)this._currentVal);
                this._currentVal = null;
            }
        } else {
            this._firstLogFileRead = false;
        }
        return this._val;
    }

    @Override
    public Pattern getFilePattern() {
        return FILE_PATTERN;
    }

    @Override
    public String getName() {
        return "yarnlogs";
    }

    @Override
    public float getProgress() {
        if (this._start == this._end) {
            return 0.0f;
        }
        try {
            return Math.min(1.0f, (float)(this._fileIn.getPos() - this._start) / (float)(this._end - this._start));
        }
        catch (Exception e) {
            return 0.0f;
        }
    }

    @Override
    public synchronized void close() throws IOException {
        IOUtils.closeQuietly((InputStream)this._currentVal);
        IOUtils.closeQuietly((Closeable)this._scanner);
        IOUtils.closeQuietly((Closeable)this._reader);
        IOUtils.closeQuietly((InputStream)this._fileIn);
    }

    public static void main(String[] args) throws Exception {
        Configuration conf = new Configuration();
        Path file = new Path(args[0]);
        FileSystem fs = file.getFileSystem(conf);
        FSDataInputStream fileIn = fs.open(file);
        TFile.Reader reader = new TFile.Reader(fileIn, fs.getFileStatus(file).getLen(), conf);
        TFile.Reader.Scanner headerScanner = reader.createScanner();
        while (!headerScanner.atEnd()) {
            StringBuilder sb;
            TFile.Reader.Scanner.Entry entry = headerScanner.entry();
            DataInputStream vin = headerScanner.entry().getValueStream();
            String key = entry.getKeyStream().readUTF();
            String value = null;
            if (key.equals("VERSION")) {
                value = String.valueOf(vin.readInt());
            } else if (key.equals("APPLICATION_OWNER")) {
                value = vin.readUTF();
            } else if (key.equals("APPLICATION_ACL")) {
                sb = new StringBuilder();
                try {
                    while (true) {
                        String k = vin.readUTF();
                        String v = vin.readUTF();
                        if (sb.length() != 0) {
                            sb.append(", ");
                        }
                        sb.append(k).append("=").append(v);
                    }
                }
                catch (EOFException e) {
                    value = sb.toString();
                }
            } else if (key.startsWith(CONTAINER_KEY_PREFIX)) {
                sb = new StringBuilder();
                try {
                    while (true) {
                        String logFileName = vin.readUTF();
                        String length = vin.readUTF();
                        int len = Integer.parseInt(length);
                        byte[] buf = new byte[len];
                        vin.read(buf);
                        if (sb.length() != 0) {
                            sb.append("\n");
                        }
                        sb.append("file=" + logFileName + "\n");
                        sb.append("length=").append(length).append("\n");
                        sb.append(new String(buf, Charset.forName("utf8")));
                    }
                }
                catch (EOFException e) {
                    value = sb.toString();
                }
            }
            vin.close();
            System.out.println("key=" + key + ", val.length=" + entry.getValueLength() + ", val=" + value);
            headerScanner.advance();
        }
    }
}

