define(
    [
        'underscore',
        'models/services/data/inputs/BaseInputModel'
    ],
    function (
        _,
        BaseInputModel
    ) {
        return BaseInputModel.extend({
            url: "data/inputs/oneshot",
            validation: {
                'ui.name': [
                    {
                        required: true,
                        msg: _("File path is required.").t()
                    }
                ],
                'ui.host': [
                    {
                        required: function() {
                            return this.wizard.get('currentStep') === 'inputsettings';
                        },
                        msg: _("Host value is required.").t()
                    }
                ]
            },
			getLabel: function () {
                return this.get("ui.name");
            },
            getValue: function () {
                return this.get("ui.name");
            }
        });
    }
);
