/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.security;

import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.mapred.Master;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenIdentifier;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkException;
import org.apache.spark.deploy.security.HadoopFSDelegationTokenProvider$;
import org.apache.spark.internal.Logging;
import org.apache.spark.security.HadoopDelegationTokenProvider;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Set;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005b!\u0002\t\u0012\u0001MY\u0002\"B\u0017\u0001\t\u0003y\u0003b\u0002\u001a\u0001\u0001\u0004%Ia\r\u0005\bu\u0001\u0001\r\u0011\"\u0003<\u0011\u0019\t\u0005\u0001)Q\u0005i!9!\t\u0001b\u0001\n\u0003\u001a\u0005BB(\u0001A\u0003%A\tC\u0003Q\u0001\u0011\u0005\u0013\u000bC\u0003j\u0001\u0011\u0005#\u000eC\u0003q\u0001\u0011%\u0011\u000fC\u0003t\u0001\u0011%A\u000fC\u0004\u0002\b\u0001!I!!\u0003\b\u0011\u0005E\u0011\u0003#\u0001\u0014\u0003'1q\u0001E\t\t\u0002M\t)\u0002\u0003\u0004.\u001b\u0011\u0005\u0011q\u0003\u0005\b\u00033iA\u0011AA\u000e\u0005}A\u0015\rZ8pa\u001a\u001bF)\u001a7fO\u0006$\u0018n\u001c8U_.,g\u000e\u0015:pm&$WM\u001d\u0006\u0003%M\t\u0001b]3dkJLG/\u001f\u0006\u0003)U\ta\u0001Z3qY>L(B\u0001\f\u0018\u0003\u0015\u0019\b/\u0019:l\u0015\tA\u0012$\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u00025\u0005\u0019qN]4\u0014\t\u0001a\"e\n\t\u0003;\u0001j\u0011A\b\u0006\u0002?\u0005)1oY1mC&\u0011\u0011E\b\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\r*S\"\u0001\u0013\u000b\u0005I)\u0012B\u0001\u0014%\u0005uA\u0015\rZ8pa\u0012+G.Z4bi&|g\u000eV8lK:\u0004&o\u001c<jI\u0016\u0014\bC\u0001\u0015,\u001b\u0005I#B\u0001\u0016\u0016\u0003!Ig\u000e^3s]\u0006d\u0017B\u0001\u0017*\u0005\u001daunZ4j]\u001e\fa\u0001P5oSRt4\u0001\u0001\u000b\u0002aA\u0011\u0011\u0007A\u0007\u0002#\u0005!Bo\\6f]J+g.Z<bY&sG/\u001a:wC2,\u0012\u0001\u000e\t\u0004;U:\u0014B\u0001\u001c\u001f\u0005\u0019y\u0005\u000f^5p]B\u0011Q\u0004O\u0005\u0003sy\u0011A\u0001T8oO\u0006ABo\\6f]J+g.Z<bY&sG/\u001a:wC2|F%Z9\u0015\u0005qz\u0004CA\u000f>\u0013\tqdD\u0001\u0003V]&$\bb\u0002!\u0004\u0003\u0003\u0005\r\u0001N\u0001\u0004q\u0012\n\u0014!\u0006;pW\u0016t'+\u001a8fo\u0006d\u0017J\u001c;feZ\fG\u000eI\u0001\fg\u0016\u0014h/[2f\u001d\u0006lW-F\u0001E!\t)EJ\u0004\u0002G\u0015B\u0011qIH\u0007\u0002\u0011*\u0011\u0011JL\u0001\u0007yI|w\u000e\u001e \n\u0005-s\u0012A\u0002)sK\u0012,g-\u0003\u0002N\u001d\n11\u000b\u001e:j]\u001eT!a\u0013\u0010\u0002\u0019M,'O^5dK:\u000bW.\u001a\u0011\u0002-=\u0014G/Y5o\t\u0016dWmZ1uS>tGk\\6f]N$B\u0001\u000e*]E\")1k\u0002a\u0001)\u0006Q\u0001.\u00193p_B\u001cuN\u001c4\u0011\u0005USV\"\u0001,\u000b\u0005]C\u0016\u0001B2p]\u001aT!!W\f\u0002\r!\fGm\\8q\u0013\tYfKA\u0007D_:4\u0017nZ;sCRLwN\u001c\u0005\u0006;\u001e\u0001\rAX\u0001\ngB\f'o[\"p]\u001a\u0004\"a\u00181\u000e\u0003UI!!Y\u000b\u0003\u0013M\u0003\u0018M]6D_:4\u0007\"B2\b\u0001\u0004!\u0017!B2sK\u0012\u001c\bCA3h\u001b\u00051'B\u0001\nY\u0013\tAgMA\u0006De\u0016$WM\u001c;jC2\u001c\u0018\u0001\u00073fY\u0016<\u0017\r^5p]R{7.\u001a8t%\u0016\fX/\u001b:fIR\u00191N\\8\u0011\u0005ua\u0017BA7\u001f\u0005\u001d\u0011un\u001c7fC:DQ!\u0018\u0005A\u0002yCQa\u0015\u0005A\u0002Q\u000bqbZ3u)>\\WM\u001c*f]\u0016<XM\u001d\u000b\u0003\tJDQaU\u0005A\u0002Q\u000bQCZ3uG\"$U\r\\3hCRLwN\u001c+pW\u0016t7\u000fF\u0003ek^\f)\u0001C\u0003w\u0015\u0001\u0007A)A\u0004sK:,w/\u001a:\t\u000baT\u0001\u0019A=\u0002\u0017\u0019LG.Z:zgR,Wn\u001d\t\u0004\u000bjd\u0018BA>O\u0005\r\u0019V\r\u001e\t\u0004{\u0006\u0005Q\"\u0001@\u000b\u0005}D\u0016A\u00014t\u0013\r\t\u0019A \u0002\u000b\r&dWmU=ti\u0016l\u0007\"B2\u000b\u0001\u0004!\u0017aF4fiR{7.\u001a8SK:,w/\u00197J]R,'O^1m)\u001d!\u00141BA\u0007\u0003\u001fAQaU\u0006A\u0002QCQ!X\u0006A\u0002yCQ\u0001_\u0006A\u0002e\fq\u0004S1e_>\u0004hi\u0015#fY\u0016<\u0017\r^5p]R{7.\u001a8Qe>4\u0018\u000eZ3s!\t\tTb\u0005\u0002\u000e9Q\u0011\u00111C\u0001\u0012Q\u0006$wn\u001c9G'N$v.Q2dKN\u001cH#B=\u0002\u001e\u0005}\u0001\"B/\u0010\u0001\u0004q\u0006\"B*\u0010\u0001\u0004!\u0006")
public class HadoopFSDelegationTokenProvider
implements HadoopDelegationTokenProvider,
Logging {
    private Option<Object> tokenRenewalInterval;
    private final String serviceName;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static Set<FileSystem> hadoopFSsToAccess(SparkConf sparkConf, Configuration configuration) {
        return HadoopFSDelegationTokenProvider$.MODULE$.hadoopFSsToAccess(sparkConf, configuration);
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$(this, isInterpreter, silent);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private Option<Object> tokenRenewalInterval() {
        return this.tokenRenewalInterval;
    }

    private void tokenRenewalInterval_$eq(Option<Object> x$1) {
        this.tokenRenewalInterval = x$1;
    }

    @Override
    public String serviceName() {
        return this.serviceName;
    }

    @Override
    public Option<Object> obtainDelegationTokens(Configuration hadoopConf, SparkConf sparkConf, Credentials creds) {
        Option option;
        try {
            Option nextRenewalDate;
            Set<FileSystem> fileSystems = HadoopFSDelegationTokenProvider$.MODULE$.hadoopFSsToAccess(sparkConf, hadoopConf);
            Credentials fetchCreds = this.fetchDelegationTokens(this.getTokenRenewer(hadoopConf), fileSystems, creds);
            if (this.tokenRenewalInterval() == null) {
                this.tokenRenewalInterval_$eq(this.getTokenRenewalInterval(hadoopConf, sparkConf, fileSystems));
            }
            option = nextRenewalDate = this.tokenRenewalInterval().flatMap((Function1 & Serializable & scala.Serializable)interval -> HadoopFSDelegationTokenProvider.$anonfun$obtainDelegationTokens$1(fetchCreds, BoxesRunTime.unboxToLong((Object)interval)));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option2 = NonFatal$.MODULE$.unapply(throwable2);
            if (option2.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option2.get();
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Failed to get token from service ").append(this.serviceName()).toString(), e);
            None$ none$ = None$.MODULE$;
            option = none$;
        }
        return option;
    }

    @Override
    public boolean delegationTokensRequired(SparkConf sparkConf, Configuration hadoopConf) {
        return UserGroupInformation.isSecurityEnabled();
    }

    /*
     * WARNING - void declaration
     */
    private String getTokenRenewer(Configuration hadoopConf) {
        void var2_2;
        String tokenRenewer = Master.getMasterPrincipal((Configuration)hadoopConf);
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Delegation token renewer is: ").append(tokenRenewer).toString());
        if (tokenRenewer == null || tokenRenewer.length() == 0) {
            String errorMessage = "Can't get Master Kerberos principal for use as renewer.";
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> errorMessage);
            throw new SparkException(errorMessage);
        }
        return var2_2;
    }

    private Credentials fetchDelegationTokens(String renewer, Set<FileSystem> filesystems, Credentials creds) {
        filesystems.foreach((Function1 & Serializable & scala.Serializable)fs -> {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("getting token for: ").append(fs).append(" with renewer ").append(renewer).toString());
            return fs.addDelegationTokens(renewer, creds);
        });
        return creds;
    }

    private Option<Object> getTokenRenewalInterval(Configuration hadoopConf, SparkConf sparkConf, Set<FileSystem> filesystems) {
        String renewer = UserGroupInformation.getCurrentUser().getUserName();
        Credentials creds = new Credentials();
        this.fetchDelegationTokens(renewer, filesystems, creds);
        Iterable renewIntervals = (Iterable)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(creds.getAllTokens()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)HadoopFSDelegationTokenProvider.$anonfun$getTokenRenewalInterval$1(x$2)))).flatMap((Function1 & Serializable & scala.Serializable)token -> Option$.MODULE$.option2Iterable(Try$.MODULE$.apply((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> {
            long newExpiration = token.renew(hadoopConf);
            AbstractDelegationTokenIdentifier identifier = (AbstractDelegationTokenIdentifier)token.decodeIdentifier();
            long interval = newExpiration - identifier.getIssueDate();
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Renewal interval is ").append(interval).append(" for token ").append(token.getKind().toString()).toString());
            return interval;
        }).toOption()), Iterable$.MODULE$.canBuildFrom());
        return renewIntervals.isEmpty() ? None$.MODULE$ : new Some(renewIntervals.min((Ordering)Ordering.Long$.MODULE$));
    }

    public static final /* synthetic */ boolean $anonfun$obtainDelegationTokens$2(Token x$1) {
        return x$1.decodeIdentifier() instanceof AbstractDelegationTokenIdentifier;
    }

    public static final /* synthetic */ long $anonfun$obtainDelegationTokens$3(long interval$1, Token token) {
        AbstractDelegationTokenIdentifier identifier = (AbstractDelegationTokenIdentifier)token.decodeIdentifier();
        return identifier.getIssueDate() + interval$1;
    }

    public static final /* synthetic */ Option $anonfun$obtainDelegationTokens$1(Credentials fetchCreds$1, long interval) {
        Iterable nextRenewalDates = (Iterable)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(fetchCreds$1.getAllTokens()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)HadoopFSDelegationTokenProvider.$anonfun$obtainDelegationTokens$2(x$1)))).map((Function1 & Serializable & scala.Serializable)token -> BoxesRunTime.boxToLong((long)HadoopFSDelegationTokenProvider.$anonfun$obtainDelegationTokens$3(interval, token)), Iterable$.MODULE$.canBuildFrom());
        return nextRenewalDates.isEmpty() ? None$.MODULE$ : new Some(nextRenewalDates.min((Ordering)Ordering.Long$.MODULE$));
    }

    public static final /* synthetic */ boolean $anonfun$getTokenRenewalInterval$1(Token x$2) {
        return x$2.decodeIdentifier() instanceof AbstractDelegationTokenIdentifier;
    }

    public HadoopFSDelegationTokenProvider() {
        Logging.$init$(this);
        this.tokenRenewalInterval = null;
        this.serviceName = "hadoopfs";
    }
}

