/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.rdd;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.InputSplitWithLocationInfo;
import org.apache.hadoop.mapred.InvalidInputException;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.lib.CombineFileSplit;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.spark.Dependency;
import org.apache.spark.InterruptibleIterator;
import org.apache.spark.Partition;
import org.apache.spark.Partitioner;
import org.apache.spark.SparkContext;
import org.apache.spark.TaskContext;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.deploy.SparkHadoopUtil$;
import org.apache.spark.executor.InputMetrics;
import org.apache.spark.internal.config.package$;
import org.apache.spark.rdd.HadoopPartition;
import org.apache.spark.rdd.HadoopRDD$;
import org.apache.spark.rdd.InputFileBlockHolder$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.util.NextIterator;
import org.apache.spark.util.SerializableConfiguration;
import org.apache.spark.util.ShutdownHookManager$;
import org.apache.spark.util.Utils$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@DeveloperApi
@ScalaSignature(bytes="\u0006\u0001\r\u0005d\u0001\u0002 @\u0001!C\u0001\u0002\u001b\u0001\u0003\u0002\u0003\u0006I!\u001b\u0005\t[\u0002\u0011\t\u0011)A\u0005]\"A!\u0010\u0001B\u0001B\u0003%1\u0010\u0003\u0006\u0002\u001a\u0001\u0011\t\u0011)A\u0005\u00037A!\"!\u0011\u0001\u0005\u0003\u0005\u000b\u0011BA\"\u0011)\t)\u0005\u0001B\u0001B\u0003%\u0011q\t\u0005\u000b\u0003\u0013\u0002!\u0011!Q\u0001\n\u0005-\u0003bBA)\u0001\u0011\u0005\u00111\u000b\u0005\b\u0003#\u0002A\u0011AA7\u0011%\t9\t\u0001b\u0001\n#\tI\t\u0003\u0005\u0002\u0012\u0002\u0001\u000b\u0011BAF\u0011%\t\u0019\n\u0001b\u0001\n#\tI\t\u0003\u0005\u0002\u0016\u0002\u0001\u000b\u0011BAF\u0011%\t9\n\u0001b\u0001\n\u0013\tI\n\u0003\u0005\u0002*\u0002\u0001\u000b\u0011BAN\u0011%\tY\u000b\u0001b\u0001\n\u0013\ti\u000b\u0003\u0005\u00026\u0002\u0001\u000b\u0011BAX\u0011%\t9\f\u0001b\u0001\n\u0013\ti\u000b\u0003\u0005\u0002:\u0002\u0001\u000b\u0011BAX\u0011%\tY\f\u0001b\u0001\n\u0013\ti\u000b\u0003\u0005\u0002>\u0002\u0001\u000b\u0011BAX\u0011%\ty\f\u0001b\u0001\n\u0013\ti\u000b\u0003\u0005\u0002B\u0002\u0001\u000b\u0011BAX\u0011\u001d\t\u0019\r\u0001C\t\u0003\u000bDq!a2\u0001\t#\tI\rC\u0004\u0002N\u0002!\t%a4\t\u000f\u0005u\u0007\u0001\"\u0011\u0002`\"9\u0011Q\u001f\u0001\u0005\u0002\u0005]\b\"\u0003B&\u0001E\u0005I\u0011\u0001B'\u0011\u001d\u0011)\u0007\u0001C!\u0005OBqAa\u001d\u0001\t\u0003\u0012)\bC\u0004\u0003x\u0001!\tE!\u001f\t\u000f\t5\u0005\u0001\"\u0001\u0003\u0010\u001eA!QT \t\u0002\u0005\u0013yJB\u0004?\u007f!\u0005\u0011I!)\t\u000f\u0005E3\u0005\"\u0001\u00030\"I!\u0011W\u0012C\u0002\u0013\u0005!1\u0017\u0005\t\u0005\u0003\u001c\u0003\u0015!\u0003\u00036\"I!1Y\u0012C\u0002\u0013\u0005!Q\u0019\u0005\t\u0005\u000f\u001c\u0003\u0015!\u0003\u0002L!9!\u0011Z\u0012\u0005\u0002\t-\u0007b\u0002BiG\u0011%!1\u001b\u0005\b\u00057\u001cC\u0011\u0001Bo\r\u001d\u0011\tp\t\u0001B\u0005gD!B!@-\u0005\u0003\u0005\u000b\u0011\u0002B\u0000\u0011)\u00119\u0002\fB\u0001B\u0003%1q\u0001\u0005\u000b\u0005wa#\u0011!Q\u0001\n\u0005=\u0006BCB\u0007Y\t\r\t\u0015a\u0003\u0004\u0010!Q1\u0011\u0003\u0017\u0003\u0004\u0003\u0006Yaa\u0005\t\u000f\u0005EC\u0006\"\u0001\u0004\u0016!I1q\u0005\u0017C\u0002\u0013\u00053\u0011\u0006\u0005\t\u0007ga\u0003\u0015!\u0003\u0004,!9\u0011Q\u001a\u0017\u0005B\u0005=\u0007bBAoY\u0011\u00053QG\u0004\u000b\u0007w\u0019\u0013\u0011!E\u0001\u0003\u000eubA\u0003ByG\u0005\u0005\t\u0012A!\u0004@!9\u0011\u0011\u000b\u001d\u0005\u0002\r\u0005\u0003\"CB\"qE\u0005I\u0011AB#\u0011%\u0019Y\u0005OA\u0001\n\u0013\u0019i\u0005\u0003\u0005\u0004P\r\"\t!QB)\u0011%\u0019YeIA\u0001\n\u0013\u0019iEA\u0005IC\u0012|w\u000e\u001d*E\t*\u0011\u0001)Q\u0001\u0004e\u0012$'B\u0001\"D\u0003\u0015\u0019\b/\u0019:l\u0015\t!U)\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\r\u0006\u0019qN]4\u0004\u0001U\u0019\u0011J\u00161\u0014\u0007\u0001Q%\rE\u0002L\u0019:k\u0011aP\u0005\u0003\u001b~\u00121A\u0015#E!\u0011y%\u000bV0\u000e\u0003AS\u0011!U\u0001\u0006g\u000e\fG.Y\u0005\u0003'B\u0013a\u0001V;qY\u0016\u0014\u0004CA+W\u0019\u0001!Qa\u0016\u0001C\u0002a\u0013\u0011aS\t\u00033r\u0003\"a\u0014.\n\u0005m\u0003&a\u0002(pi\"Lgn\u001a\t\u0003\u001fvK!A\u0018)\u0003\u0007\u0005s\u0017\u0010\u0005\u0002VA\u0012)\u0011\r\u0001b\u00011\n\ta\u000b\u0005\u0002dM6\tAM\u0003\u0002f\u0003\u0006A\u0011N\u001c;fe:\fG.\u0003\u0002hI\n9Aj\\4hS:<\u0017AA:d!\tQ7.D\u0001B\u0013\ta\u0017I\u0001\u0007Ta\u0006\u00148nQ8oi\u0016DH/A\bce>\fGmY1ti\u0016$7i\u001c8g!\ry'\u000f^\u0007\u0002a*\u0011\u0011/Q\u0001\nEJ|\u0017\rZ2bgRL!a\u001d9\u0003\u0013\t\u0013x.\u00193dCN$\bCA;y\u001b\u00051(BA<B\u0003\u0011)H/\u001b7\n\u0005e4(!G*fe&\fG.\u001b>bE2,7i\u001c8gS\u001e,(/\u0019;j_:\fq#\u001b8ji2{7-\u00197K_\n\u001cuN\u001c4Gk:\u001cw\n\u001d;\u0011\u0007=ch0\u0003\u0002~!\n1q\n\u001d;j_:\u0004baT@\u0002\u0004\u0005M\u0011bAA\u0001!\nIa)\u001e8di&|g.\r\t\u0005\u0003\u000b\ty!\u0004\u0002\u0002\b)!\u0011\u0011BA\u0006\u0003\u0019i\u0017\r\u001d:fI*\u0019\u0011QB\"\u0002\r!\fGm\\8q\u0013\u0011\t\t\"a\u0002\u0003\u000f){'mQ8oMB\u0019q*!\u0006\n\u0007\u0005]\u0001K\u0001\u0003V]&$\u0018\u0001E5oaV$hi\u001c:nCR\u001cE.Y:ta\u0011\ti\"!\u000e\u0011\r\u0005}\u0011QFA\u001a\u001d\u0011\t\t#!\u000b\u0011\u0007\u0005\r\u0002+\u0004\u0002\u0002&)\u0019\u0011qE$\u0002\rq\u0012xn\u001c;?\u0013\r\tY\u0003U\u0001\u0007!J,G-\u001a4\n\t\u0005=\u0012\u0011\u0007\u0002\u0006\u00072\f7o\u001d\u0006\u0004\u0003W\u0001\u0006cA+\u00026\u0011Y\u0011q\u0007\u0003\u0002\u0002\u0003\u0005)\u0011AA\u001d\u0005\ryF%M\t\u00043\u0006m\u0002CBA\u0003\u0003{!v,\u0003\u0003\u0002@\u0005\u001d!aC%oaV$hi\u001c:nCR\f\u0001b[3z\u00072\f7o\u001d\t\u0006\u0003?\ti\u0003V\u0001\u000bm\u0006dW/Z\"mCN\u001c\b#BA\u0010\u0003[y\u0016!D7j]B\u000b'\u000f^5uS>t7\u000fE\u0002P\u0003\u001bJ1!a\u0014Q\u0005\rIe\u000e^\u0001\u0007y%t\u0017\u000e\u001e \u0015!\u0005U\u0013qKA-\u00037\ni&a\u001a\u0002j\u0005-\u0004\u0003B&\u0001)~CQ\u0001\u001b\u0005A\u0002%DQ!\u001c\u0005A\u00029DQA\u001f\u0005A\u0002mDq!!\u0007\t\u0001\u0004\ty\u0006\r\u0003\u0002b\u0005\u0015\u0004CBA\u0010\u0003[\t\u0019\u0007E\u0002V\u0003K\"A\"a\u000e\u0002^\u0005\u0005\t\u0011!B\u0001\u0003sAq!!\u0011\t\u0001\u0004\t\u0019\u0005C\u0004\u0002F!\u0001\r!a\u0012\t\u000f\u0005%\u0003\u00021\u0001\u0002LQq\u0011QKA8\u0003c\n)(!!\u0002\u0004\u0006\u0015\u0005\"\u00025\n\u0001\u0004I\u0007bBA:\u0013\u0001\u0007\u00111A\u0001\u0005G>tg\rC\u0004\u0002\u001a%\u0001\r!a\u001e1\t\u0005e\u0014Q\u0010\t\u0007\u0003?\ti#a\u001f\u0011\u0007U\u000bi\b\u0002\u0007\u0002\u0000\u0005U\u0014\u0011!A\u0001\u0006\u0003\tIDA\u0002`IIBq!!\u0011\n\u0001\u0004\t\u0019\u0005C\u0004\u0002F%\u0001\r!a\u0012\t\u000f\u0005%\u0013\u00021\u0001\u0002L\u0005y!n\u001c2D_:47)Y2iK.+\u00170\u0006\u0002\u0002\fB!\u0011qDAG\u0013\u0011\ty)!\r\u0003\rM#(/\u001b8h\u0003AQwNY\"p]\u001a\u001c\u0015m\u00195f\u0017\u0016L\b%A\nj]B,HOR8s[\u0006$8)Y2iK.+\u00170\u0001\u000bj]B,HOR8s[\u0006$8)Y2iK.+\u0017\u0010I\u0001\u000bGJ,\u0017\r^3US6,WCAAN!\u0011\ti*!*\u000e\u0005\u0005}%bA<\u0002\"*\u0011\u00111U\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002(\u0006}%\u0001\u0002#bi\u0016\f1b\u0019:fCR,G+[7fA\u0005\u00112\u000f[8vY\u0012\u001cEn\u001c8f\u0015>\u00147i\u001c8g+\t\ty\u000bE\u0002P\u0003cK1!a-Q\u0005\u001d\u0011un\u001c7fC:\f1c\u001d5pk2$7\t\\8oK*{'mQ8oM\u0002\n!#[4o_J,7i\u001c:skB$h)\u001b7fg\u0006\u0019\u0012n\u001a8pe\u0016\u001cuN\u001d:vaR4\u0015\u000e\\3tA\u0005\u0011\u0012n\u001a8pe\u0016l\u0015n]:j]\u001e4\u0015\u000e\\3t\u0003MIwM\\8sK6K7o]5oO\u001aKG.Z:!\u0003EIwM\\8sK\u0016k\u0007\u000f^=Ta2LGo]\u0001\u0013S\u001etwN]3F[B$\u0018p\u00159mSR\u001c\b%\u0001\u0006hKRTuNY\"p]\u001a$\"!a\u0001\u0002\u001d\u001d,G/\u00138qkR4uN]7biR!\u00111HAf\u0011\u001d\t\u0019(\u0007a\u0001\u0003\u0007\tQbZ3u!\u0006\u0014H/\u001b;j_:\u001cXCAAi!\u0015y\u00151[Al\u0013\r\t)\u000e\u0015\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0004U\u0006e\u0017bAAn\u0003\nI\u0001+\u0019:uSRLwN\\\u0001\bG>l\u0007/\u001e;f)\u0019\t\t/a:\u0002lB!!.a9O\u0013\r\t)/\u0011\u0002\u0016\u0013:$XM\u001d:vaRL'\r\\3Ji\u0016\u0014\u0018\r^8s\u0011\u001d\tIo\u0007a\u0001\u0003/\f\u0001\u0002\u001e5f'Bd\u0017\u000e\u001e\u0005\b\u0003[\\\u0002\u0019AAx\u0003\u001d\u0019wN\u001c;fqR\u00042A[Ay\u0013\r\t\u00190\u0011\u0002\f)\u0006\u001c8nQ8oi\u0016DH/A\u000enCB\u0004\u0016M\u001d;ji&|gn],ji\"Le\u000e];u'Bd\u0017\u000e^\u000b\u0005\u0003s\u0014\t\u0001\u0006\u0004\u0002|\nU!\u0011\b\u000b\u0005\u0003{\u0014)\u0001\u0005\u0003L\u0019\u0006}\bcA+\u0003\u0002\u00111!1\u0001\u000fC\u0002a\u0013\u0011!\u0016\u0005\n\u0005\u000fa\u0012\u0011!a\u0002\u0005\u0013\t!\"\u001a<jI\u0016t7-\u001a\u00132!\u0019\u0011YA!\u0005\u0002\u00006\u0011!Q\u0002\u0006\u0004\u0005\u001f\u0001\u0016a\u0002:fM2,7\r^\u0005\u0005\u0005'\u0011iA\u0001\u0005DY\u0006\u001c8\u000fV1h\u0011\u001d\u00119\u0002\ba\u0001\u00053\t\u0011A\u001a\t\n\u001f\nm!q\u0004B\u0013\u0005oI1A!\bQ\u0005%1UO\\2uS>t'\u0007\u0005\u0003\u0002\u0006\t\u0005\u0012\u0002\u0002B\u0012\u0003\u000f\u0011!\"\u00138qkR\u001c\u0006\u000f\\5u!\u0015\u00119C!\rO\u001d\u0011\u0011IC!\f\u000f\t\u0005\r\"1F\u0005\u0002#&\u0019!q\u0006)\u0002\u000fA\f7m[1hK&!!1\u0007B\u001b\u0005!IE/\u001a:bi>\u0014(b\u0001B\u0018!B1!q\u0005B\u0019\u0003\u007fD\u0011Ba\u000f\u001d!\u0003\u0005\r!a,\u0002+A\u0014Xm]3sm\u0016\u001c\b+\u0019:uSRLwN\\5oO\"\u001aADa\u0010\u0011\t\t\u0005#qI\u0007\u0003\u0005\u0007R1A!\u0012B\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005\u0013\u0012\u0019E\u0001\u0007EKZ,Gn\u001c9fe\u0006\u0003\u0018.A\u0013nCB\u0004\u0016M\u001d;ji&|gn],ji\"Le\u000e];u'Bd\u0017\u000e\u001e\u0013eK\u001a\fW\u000f\u001c;%eU!!q\nB2+\t\u0011\tF\u000b\u0003\u00020\nM3F\u0001B+!\u0011\u00119Fa\u0018\u000e\u0005\te#\u0002\u0002B.\u0005;\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\t\u0015\u0003+\u0003\u0003\u0003b\te#!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u00121!1A\u000fC\u0002a\u000bQcZ3u!J,g-\u001a:sK\u0012dunY1uS>t7\u000f\u0006\u0003\u0003j\t=\u0004C\u0002B\u0014\u0005W\nY)\u0003\u0003\u0003n\tU\"aA*fc\"9!\u0011\u000f\u0010A\u0002\u0005]\u0017!B:qY&$\u0018AC2iK\u000e\\\u0007o\\5oiR\u0011\u00111C\u0001\ba\u0016\u00148/[:u)\u0011\u0011YH! \u000e\u0003\u0001AqAa !\u0001\u0004\u0011\t)\u0001\u0007ti>\u0014\u0018mZ3MKZ,G\u000e\u0005\u0003\u0003\u0004\n%UB\u0001BC\u0015\r\u00119)Q\u0001\bgR|'/Y4f\u0013\u0011\u0011YI!\"\u0003\u0019M#xN]1hK2+g/\u001a7\u0002\u000f\u001d,GoQ8oMV\u0011!\u0011\u0013\t\u0005\u0005'\u00139*\u0004\u0002\u0003\u0016*!\u00111OA\u0006\u0013\u0011\u0011IJ!&\u0003\u001b\r{gNZ5hkJ\fG/[8oQ\r\u0001!qH\u0001\n\u0011\u0006$wn\u001c9S\t\u0012\u0003\"aS\u0012\u0014\r\r\u0012\u0019K\u0019BU!\ry%QU\u0005\u0004\u0005O\u0003&AB!osJ+g\rE\u0002P\u0005WK1A!,Q\u00051\u0019VM]5bY&T\u0018M\u00197f)\t\u0011y*\u0001\u0011D\u001f:3\u0015jR+S\u0003RKuJT0J\u001dN#\u0016I\u0014+J\u0003RKuJT0M\u001f\u000e[UC\u0001B[!\u0011\u00119L!0\u000e\u0005\te&\u0002\u0002B^\u0003C\u000bA\u0001\\1oO&!!q\u0018B]\u0005\u0019y%M[3di\u0006\t3i\u0014(G\u0013\u001e+&+\u0011+J\u001f:{\u0016JT*U\u0003:#\u0016*\u0011+J\u001f:{FjT\"LA\u0005I#+R\"P%\u0012\u001bvLQ#U/\u0016+ej\u0018\"Z)\u0016\u001bvLU#B\t~kU\t\u0016*J\u0007~+\u0006\u000bR!U\u000bN+\"!a\u0013\u0002UI+5i\u0014*E'~\u0013U\tV,F\u000b:{&)\u0017+F'~\u0013V)\u0011#`\u001b\u0016#&+S\"`+B#\u0015\tV#TA\u0005\tr-\u001a;DC\u000eDW\rZ'fi\u0006$\u0017\r^1\u0015\t\t\r&Q\u001a\u0005\b\u0005\u001fL\u0003\u0019AAF\u0003\rYW-_\u0001\u0012aV$8)Y2iK\u0012lU\r^1eCR\fGCBA\n\u0005+\u00149\u000eC\u0004\u0003P*\u0002\r!a#\t\u000f\te'\u00061\u0001\u0003$\u0006)a/\u00197vK\u0006)\u0012\r\u001a3M_\u000e\fGnQ8oM&<WO]1uS>tG\u0003DA\n\u0005?\u0014\u0019Oa:\u0003l\n=\bb\u0002BqW\u0001\u0007\u00111R\u0001\rU>\u0014GK]1dW\u0016\u0014\u0018\n\u001a\u0005\b\u0005K\\\u0003\u0019AA&\u0003\u0015QwNY%e\u0011\u001d\u0011Io\u000ba\u0001\u0003\u0017\nqa\u001d9mSRLE\rC\u0004\u0003n.\u0002\r!a\u0013\u0002\u0013\u0005$H/Z7qi&#\u0007bBA:W\u0001\u0007\u00111\u0001\u0002 \u0011\u0006$wn\u001c9NCB\u0004\u0016M\u001d;ji&|gn],ji\"\u001c\u0006\u000f\\5u%\u0012#UC\u0002B{\u0005w\u001c\u0019aE\u0002-\u0005o\u0004Ba\u0013'\u0003zB\u0019QKa?\u0005\r\t\rAF1\u0001Y\u0003\u0011\u0001(/\u001a<\u0011\t-c5\u0011\u0001\t\u0004+\u000e\rAABB\u0003Y\t\u0007\u0001LA\u0001U!%y%1\u0004B\u0010\u0007\u0013\u0019Y\u0001\u0005\u0004\u0003(\tE2\u0011\u0001\t\u0007\u0005O\u0011\tD!?\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$#\u0007\u0005\u0004\u0003\f\tE!\u0011`\u0001\u000bKZLG-\u001a8dK\u0012\u001a\u0004C\u0002B\u0006\u0005#\u0019\t\u0001\u0006\u0005\u0004\u0018\r\u000521EB\u0013)\u0019\u0019Ib!\b\u0004 A911\u0004\u0017\u0003z\u000e\u0005Q\"A\u0012\t\u000f\r5!\u0007q\u0001\u0004\u0010!91\u0011\u0003\u001aA\u0004\rM\u0001b\u0002B\u007fe\u0001\u0007!q \u0005\b\u0005/\u0011\u0004\u0019AB\u0004\u0011%\u0011YD\rI\u0001\u0002\u0004\ty+A\u0006qCJ$\u0018\u000e^5p]\u0016\u0014XCAB\u0016!\u0011yEp!\f\u0011\u0007)\u001cy#C\u0002\u00042\u0005\u00131\u0002U1si&$\u0018n\u001c8fe\u0006a\u0001/\u0019:uSRLwN\\3sAQ111BB\u001c\u0007sAqA!\u001d7\u0001\u0004\t9\u000eC\u0004\u0002nZ\u0002\r!a<\u0002?!\u000bGm\\8q\u001b\u0006\u0004\b+\u0019:uSRLwN\\:XSRD7\u000b\u001d7jiJ#E\tE\u0002\u0004\u001ca\u001aR\u0001\u000fBR\u0005S#\"a!\u0010\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00134+\u0019\u0011yea\u0012\u0004J\u00111!1\u0001\u001eC\u0002a#aa!\u0002;\u0005\u0004A\u0016a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"A!.\u00021\r|gN^3siN\u0003H.\u001b;M_\u000e\fG/[8o\u0013:4w\u000e\u0006\u0003\u0004T\rU\u0003\u0003B(}\u0005SBqaa\u0016=\u0001\u0004\u0019I&A\u0003j]\u001a|7\u000fE\u0003P\u0003'\u001cY\u0006\u0005\u0003\u0002\u0006\ru\u0013\u0002BB0\u0003\u000f\u0011\u0011c\u00159mSRdunY1uS>t\u0017J\u001c4p\u0001")
public class HadoopRDD<K, V>
extends RDD<Tuple2<K, V>> {
    private final Broadcast<SerializableConfiguration> broadcastedConf;
    private final Option<Function1<JobConf, BoxedUnit>> initLocalJobConfFuncOpt;
    private final Class<? extends InputFormat<K, V>> inputFormatClass;
    private final int minPartitions;
    private final String jobConfCacheKey;
    private final String inputFormatCacheKey;
    private final Date org$apache$spark$rdd$HadoopRDD$$createTime;
    private final boolean shouldCloneJobConf;
    private final boolean org$apache$spark$rdd$HadoopRDD$$ignoreCorruptFiles;
    private final boolean org$apache$spark$rdd$HadoopRDD$$ignoreMissingFiles;
    private final boolean ignoreEmptySplits;

    public static void addLocalConfiguration(String string, int n, int n2, int n3, JobConf jobConf) {
        HadoopRDD$.MODULE$.addLocalConfiguration(string, n, n2, n3, jobConf);
    }

    public static Object getCachedMetadata(String string) {
        return HadoopRDD$.MODULE$.getCachedMetadata(string);
    }

    public static int RECORDS_BETWEEN_BYTES_READ_METRIC_UPDATES() {
        return HadoopRDD$.MODULE$.RECORDS_BETWEEN_BYTES_READ_METRIC_UPDATES();
    }

    public static Object CONFIGURATION_INSTANTIATION_LOCK() {
        return HadoopRDD$.MODULE$.CONFIGURATION_INSTANTIATION_LOCK();
    }

    public String jobConfCacheKey() {
        return this.jobConfCacheKey;
    }

    public String inputFormatCacheKey() {
        return this.inputFormatCacheKey;
    }

    public Date org$apache$spark$rdd$HadoopRDD$$createTime() {
        return this.org$apache$spark$rdd$HadoopRDD$$createTime;
    }

    private boolean shouldCloneJobConf() {
        return this.shouldCloneJobConf;
    }

    public boolean org$apache$spark$rdd$HadoopRDD$$ignoreCorruptFiles() {
        return this.org$apache$spark$rdd$HadoopRDD$$ignoreCorruptFiles;
    }

    public boolean org$apache$spark$rdd$HadoopRDD$$ignoreMissingFiles() {
        return this.org$apache$spark$rdd$HadoopRDD$$ignoreMissingFiles;
    }

    private boolean ignoreEmptySplits() {
        return this.ignoreEmptySplits;
    }

    public JobConf getJobConf() {
        JobConf jobConf;
        Configuration conf2 = this.broadcastedConf.value().value();
        if (this.shouldCloneJobConf()) {
            Object object = HadoopRDD$.MODULE$.CONFIGURATION_INSTANTIATION_LOCK();
            synchronized (object) {
                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Cloning Hadoop Configuration");
                JobConf newJobConf = new JobConf(conf2);
                if (!(conf2 instanceof JobConf)) {
                    this.initLocalJobConfFuncOpt.foreach((Function1 & Serializable & scala.Serializable)f -> {
                        f.apply((Object)newJobConf);
                        return BoxedUnit.UNIT;
                    });
                }
                JobConf jobConf2 = newJobConf;
                // MONITOREXIT @DISABLED, blocks:[0, 1, 7] lbl11 : MonitorExitStatement: MONITOREXIT : var2_2
                jobConf = jobConf2;
            }
        } else if (conf2 instanceof JobConf) {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Re-using user-broadcasted JobConf");
            jobConf = (JobConf)conf2;
        } else {
            jobConf = (JobConf)Option$.MODULE$.apply(HadoopRDD$.MODULE$.getCachedMetadata(this.jobConfCacheKey())).map((Function1 & Serializable & scala.Serializable)conf -> {
                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Re-using cached JobConf");
                return (JobConf)conf;
            }).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                JobConf jobConf;
                Object object = HadoopRDD$.MODULE$.CONFIGURATION_INSTANTIATION_LOCK();
                synchronized (object) {
                    this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Creating new JobConf and caching it for later re-use");
                    JobConf newJobConf = new JobConf(conf2);
                    $this.initLocalJobConfFuncOpt.foreach((Function1 & Serializable & scala.Serializable)f -> {
                        f.apply((Object)newJobConf);
                        return BoxedUnit.UNIT;
                    });
                    HadoopRDD$.MODULE$.org$apache$spark$rdd$HadoopRDD$$putCachedMetadata(this.jobConfCacheKey(), newJobConf);
                    jobConf = newJobConf;
                }
                return jobConf;
            });
        }
        return jobConf;
    }

    /*
     * WARNING - void declaration
     */
    public InputFormat<K, V> getInputFormat(JobConf conf) {
        void var3_2;
        InputFormat newInputFormat = (InputFormat)ReflectionUtils.newInstance(this.inputFormatClass, (Configuration)conf);
        InputFormat inputFormat = newInputFormat;
        if (inputFormat instanceof Configurable) {
            InputFormat inputFormat2 = inputFormat;
            ((Configurable)inputFormat2).setConf((Configuration)conf);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        return var3_2;
    }

    @Override
    public Partition[] getPartitions() {
        Partition[] partitionArray;
        JobConf jobConf = this.getJobConf();
        SparkHadoopUtil$.MODULE$.get().addCredentials(jobConf);
        try {
            InputSplit[] inputSplits;
            InputSplit[] allInputSplits = this.getInputFormat(jobConf).getSplits(jobConf, this.minPartitions);
            InputSplit[] inputSplitArray = inputSplits = this.ignoreEmptySplits() ? (InputSplit[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])allInputSplits)).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)HadoopRDD.$anonfun$getPartitions$1(x$1))) : allInputSplits;
            if (inputSplits.length == 1 && inputSplits[0] instanceof FileSplit) {
                FileSplit fileSplit = (FileSplit)inputSplits[0];
                Path path = fileSplit.getPath();
                if (fileSplit.getLength() > BoxesRunTime.unboxToLong((Object)this.conf().get(package$.MODULE$.IO_WARNING_LARGEFILETHRESHOLD()))) {
                    CompressionCodecFactory codecFactory = new CompressionCodecFactory((Configuration)jobConf);
                    if (Utils$.MODULE$.isFileSplittable(path, codecFactory)) {
                        this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(109).append("Loading one large file ").append(path.toString()).append(" with only one partition, ").append("we can increase partition numbers for improving performance.").toString());
                    } else {
                        this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(127).append("Loading one large unsplittable file ").append(path.toString()).append(" with only one ").append("partition, because the file is compressed by unsplittable compression codec.").toString());
                    }
                }
            }
            Partition[] array = new Partition[new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])inputSplits)).size()];
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])inputSplits)).size()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                array$1[i] = new HadoopPartition(this.id(), i, inputSplits[i]);
            });
            partitionArray = array;
        }
        catch (Throwable throwable) {
            InvalidInputException invalidInputException;
            block10: {
                block9: {
                    Throwable throwable2 = throwable;
                    if (!(throwable2 instanceof InvalidInputException)) break block9;
                    invalidInputException = (InvalidInputException)throwable2;
                    if (this.org$apache$spark$rdd$HadoopRDD$$ignoreMissingFiles()) break block10;
                }
                throw throwable;
            }
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(57).append(jobConf.get("mapreduce.input.fileinputformat.inputdir")).append(" doesn't exist and no").append(" partitions returned from this path.").toString(), (Throwable)invalidInputException);
            Partition[] partitionArray2 = (Partition[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Partition.class));
            partitionArray = partitionArray2;
        }
        return partitionArray;
    }

    @Override
    public InterruptibleIterator<Tuple2<K, V>> compute(Partition theSplit, TaskContext context) {
        NextIterator iter = new NextIterator<Tuple2<K, V>>(this, context, theSplit){
            private final HadoopPartition split;
            private final JobConf jobConf;
            private final InputMetrics inputMetrics;
            private final long existingBytesRead;
            private final Option<Function0<Object>> getBytesReadCallback;
            private RecordReader<K, V> reader;
            private final InputFormat<K, V> inputFormat;
            private final K key;
            private final V value;
            private final /* synthetic */ HadoopRDD $outer;

            private HadoopPartition split() {
                return this.split;
            }

            private JobConf jobConf() {
                return this.jobConf;
            }

            private InputMetrics inputMetrics() {
                return this.inputMetrics;
            }

            private long existingBytesRead() {
                return this.existingBytesRead;
            }

            private Option<Function0<Object>> getBytesReadCallback() {
                return this.getBytesReadCallback;
            }

            private void updateBytesRead() {
                this.getBytesReadCallback().foreach((Function1 & Serializable & scala.Serializable)getBytesRead -> {
                    $anon$1.$anonfun$updateBytesRead$1(this, getBytesRead);
                    return BoxedUnit.UNIT;
                });
            }

            private RecordReader<K, V> reader() {
                return this.reader;
            }

            private void reader_$eq(RecordReader<K, V> x$1) {
                this.reader = x$1;
            }

            private InputFormat<K, V> inputFormat() {
                return this.inputFormat;
            }

            private K key() {
                return this.key;
            }

            private V value() {
                return this.value;
            }

            public Tuple2<K, V> getNext() {
                try {
                    this.finished_$eq(!this.reader().next(this.key(), this.value()));
                }
                catch (Throwable throwable) {
                    boolean bl = false;
                    FileNotFoundException fileNotFoundException = null;
                    Throwable throwable2 = throwable;
                    if (throwable2 instanceof FileNotFoundException) {
                        bl = true;
                        fileNotFoundException = (FileNotFoundException)throwable2;
                        if (this.$outer.org$apache$spark$rdd$HadoopRDD$$ignoreMissingFiles()) {
                            this.$outer.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(22).append("Skipped missing file: ").append(this.split().inputSplit()).toString(), fileNotFoundException);
                            this.finished_$eq(true);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        }
                    }
                    if (bl && !this.$outer.org$apache$spark$rdd$HadoopRDD$$ignoreMissingFiles()) {
                        throw fileNotFoundException;
                    }
                    if (throwable2 instanceof IOException) {
                        IOException iOException = (IOException)throwable2;
                        if (this.$outer.org$apache$spark$rdd$HadoopRDD$$ignoreCorruptFiles()) {
                            this.$outer.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("Skipped the rest content in the corrupted file: ").append(this.split().inputSplit()).toString(), iOException);
                            this.finished_$eq(true);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        }
                    }
                    throw throwable;
                }
                if (!this.finished()) {
                    this.inputMetrics().incRecordsRead(1L);
                }
                if (this.inputMetrics().recordsRead() % (long)SparkHadoopUtil$.MODULE$.UPDATE_INPUT_METRICS_INTERVAL_RECORDS() == 0L) {
                    this.updateBytesRead();
                }
                return new Tuple2(this.key(), this.value());
            }

            public void close() {
                block9: {
                    block10: {
                        if (this.reader() == null) break block9;
                        InputFileBlockHolder$.MODULE$.unset();
                        try {
                            try {
                                this.reader().close();
                            }
                            catch (Exception e) {
                                if (!ShutdownHookManager$.MODULE$.inShutdown()) {
                                    this.$outer.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Exception in RecordReader.close()", e);
                                }
                            }
                        }
                        finally {
                            this.reader_$eq(null);
                        }
                        if (!this.getBytesReadCallback().isDefined()) break block10;
                        this.updateBytesRead();
                        break block9;
                    }
                    if (!(this.split().inputSplit().value() instanceof FileSplit) && !(this.split().inputSplit().value() instanceof CombineFileSplit)) break block9;
                    try {
                        this.inputMetrics().incBytesRead(this.split().inputSplit().value().getLength());
                    }
                    catch (IOException e) {
                        this.$outer.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Unable to get input size to set InputMetrics for task", e);
                    }
                }
            }

            public static final /* synthetic */ void $anonfun$updateBytesRead$1($anon$1 $this, Function0 getBytesRead) {
                $this.inputMetrics().setBytesRead($this.existingBytesRead() + getBytesRead.apply$mcJ$sp());
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            private final RecordReader liftedTree1$1() {
                try {
                    RecordReader recordReader = this.inputFormat().getRecordReader(this.split().inputSplit().value(), this.jobConf(), Reporter.NULL);
                    return recordReader;
                }
                catch (Throwable throwable) {
                    boolean bl = false;
                    FileNotFoundException fileNotFoundException = null;
                    Throwable throwable2 = throwable;
                    if (throwable2 instanceof FileNotFoundException) {
                        bl = true;
                        fileNotFoundException = (FileNotFoundException)throwable2;
                        if (this.$outer.org$apache$spark$rdd$HadoopRDD$$ignoreMissingFiles()) {
                            this.$outer.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(22).append("Skipped missing file: ").append(this.split().inputSplit()).toString(), fileNotFoundException);
                            this.finished_$eq(true);
                            return null;
                        }
                    }
                    if (bl && !this.$outer.org$apache$spark$rdd$HadoopRDD$$ignoreMissingFiles()) {
                        throw fileNotFoundException;
                    }
                    if (!(throwable2 instanceof IOException)) throw throwable;
                    IOException iOException = (IOException)throwable2;
                    if (!this.$outer.org$apache$spark$rdd$HadoopRDD$$ignoreCorruptFiles()) throw throwable;
                    this.$outer.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("Skipped the rest content in the corrupted file: ").append(this.split().inputSplit()).toString(), iOException);
                    this.finished_$eq(true);
                    return null;
                }
            }

            public static final /* synthetic */ void $anonfun$new$4($anon$1 $this, TaskContext context) {
                $this.updateBytesRead();
                $this.closeIfNeeded();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.split = (HadoopPartition)theSplit$1;
                $outer.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(13).append("Input split: ").append(this.split().inputSplit()).toString());
                this.jobConf = $outer.getJobConf();
                this.inputMetrics = context$1.taskMetrics().inputMetrics();
                this.existingBytesRead = this.inputMetrics().bytesRead();
                InputSplit inputSplit = this.split().inputSplit().value();
                if (inputSplit instanceof FileSplit) {
                    FileSplit fileSplit = (FileSplit)inputSplit;
                    InputFileBlockHolder$.MODULE$.set(fileSplit.getPath().toString(), fileSplit.getStart(), fileSplit.getLength());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    InputFileBlockHolder$.MODULE$.unset();
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                InputSplit inputSplit2 = this.split().inputSplit().value();
                boolean bl = inputSplit2 instanceof FileSplit ? true : inputSplit2 instanceof CombineFileSplit;
                Object object = bl ? new Some(SparkHadoopUtil$.MODULE$.get().getFSBytesReadOnThreadCallback()) : None$.MODULE$;
                this.getBytesReadCallback = object;
                this.reader = null;
                this.inputFormat = $outer.getInputFormat(this.jobConf());
                HadoopRDD$.MODULE$.addLocalConfiguration(new SimpleDateFormat("yyyyMMddHHmmss", Locale.US).format($outer.org$apache$spark$rdd$HadoopRDD$$createTime()), context$1.stageId(), theSplit$1.index(), context$1.attemptNumber(), this.jobConf());
                this.reader_$eq(this.liftedTree1$1());
                context$1.addTaskCompletionListener((Function1 & Serializable & scala.Serializable)context -> {
                    $anon$1.$anonfun$new$4(this, context);
                    return BoxedUnit.UNIT;
                });
                this.key = this.reader() == null ? null : this.reader().createKey();
                this.value = this.reader() == null ? null : this.reader().createValue();
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$updateBytesRead$1$adapted(org.apache.spark.rdd.HadoopRDD$$anon$1 scala.Function0 ), $anonfun$getNext$1(org.apache.spark.rdd.HadoopRDD$$anon$1 ), $anonfun$getNext$2(org.apache.spark.rdd.HadoopRDD$$anon$1 ), $anonfun$close$1(), $anonfun$close$2(), $anonfun$new$2(org.apache.spark.rdd.HadoopRDD$$anon$1 ), $anonfun$new$3(org.apache.spark.rdd.HadoopRDD$$anon$1 ), $anonfun$new$1(org.apache.spark.rdd.HadoopRDD$$anon$1 ), $anonfun$new$4$adapted(org.apache.spark.rdd.HadoopRDD$$anon$1 org.apache.spark.TaskContext )}, serializedLambda);
            }
        };
        return new InterruptibleIterator<Tuple2<K, V>>(context, iter);
    }

    @DeveloperApi
    public <U> RDD<U> mapPartitionsWithInputSplit(Function2<InputSplit, Iterator<Tuple2<K, V>>, Iterator<U>> f, boolean preservesPartitioning, ClassTag<U> evidence$1) {
        return new HadoopMapPartitionsWithSplitRDD<U, Tuple2<K, V>>(this, f, preservesPartitioning, evidence$1, ClassTag$.MODULE$.apply(Tuple2.class));
    }

    public <U> boolean mapPartitionsWithInputSplit$default$2() {
        return false;
    }

    @Override
    public Seq<String> getPreferredLocations(Partition split) {
        Option<Seq<String>> option;
        InputSplit hsplit = ((HadoopPartition)split).inputSplit().value();
        InputSplit inputSplit = hsplit;
        if (inputSplit instanceof InputSplitWithLocationInfo) {
            InputSplitWithLocationInfo inputSplitWithLocationInfo = (InputSplitWithLocationInfo)inputSplit;
            option = HadoopRDD$.MODULE$.convertSplitLocationInfo(inputSplitWithLocationInfo.getLocationInfo());
        } else {
            option = None$.MODULE$;
        }
        Option<Seq<String>> locs = option;
        return (Seq)locs.getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])hsplit.getLocations())).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)HadoopRDD.$anonfun$getPreferredLocations$2(x$2)))));
    }

    @Override
    public void checkpoint() {
    }

    public HadoopRDD<K, V> persist(StorageLevel storageLevel) {
        block0: {
            if (!storageLevel.deserialized()) break block0;
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Caching HadoopRDDs as deserialized objects usually leads to undesired behavior because Hadoop's RecordReader reuses the same Writable object for all records. Use a map transformation to make copies of the records.");
        }
        return (HadoopRDD)super.persist(storageLevel);
    }

    public Configuration getConf() {
        return this.getJobConf();
    }

    public static final /* synthetic */ boolean $anonfun$getPartitions$1(InputSplit x$1) {
        return x$1.getLength() > 0L;
    }

    public static final /* synthetic */ boolean $anonfun$getPreferredLocations$2(String x$2) {
        String string = x$2;
        String string2 = "localhost";
        return string == null ? string2 != null : !string.equals(string2);
    }

    public HadoopRDD(SparkContext sc, Broadcast<SerializableConfiguration> broadcastedConf, Option<Function1<JobConf, BoxedUnit>> initLocalJobConfFuncOpt, Class<? extends InputFormat<K, V>> inputFormatClass, Class<K> keyClass, Class<V> valueClass, int minPartitions) {
        BoxedUnit boxedUnit;
        this.broadcastedConf = broadcastedConf;
        this.initLocalJobConfFuncOpt = initLocalJobConfFuncOpt;
        this.inputFormatClass = inputFormatClass;
        this.minPartitions = minPartitions;
        super(sc, (Seq<Dependency<?>>)Nil$.MODULE$, ClassTag$.MODULE$.apply(Tuple2.class));
        if (initLocalJobConfFuncOpt.isDefined()) {
            SparkContext qual$1 = this.sparkContext();
            Function1 x$1 = (Function1)initLocalJobConfFuncOpt.get();
            boolean x$2 = qual$1.clean$default$2();
            boxedUnit = qual$1.clean(x$1, x$2);
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.jobConfCacheKey = new StringOps(Predef$.MODULE$.augmentString("rdd_%d_job_conf")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.id())}));
        this.inputFormatCacheKey = new StringOps(Predef$.MODULE$.augmentString("rdd_%d_input_format")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.id())}));
        this.org$apache$spark$rdd$HadoopRDD$$createTime = new Date();
        this.shouldCloneJobConf = this.sparkContext().conf().getBoolean("spark.hadoop.cloneConf", false);
        this.org$apache$spark$rdd$HadoopRDD$$ignoreCorruptFiles = BoxesRunTime.unboxToBoolean((Object)this.sparkContext().conf().get(package$.MODULE$.IGNORE_CORRUPT_FILES()));
        this.org$apache$spark$rdd$HadoopRDD$$ignoreMissingFiles = BoxesRunTime.unboxToBoolean((Object)this.sparkContext().conf().get(package$.MODULE$.IGNORE_MISSING_FILES()));
        this.ignoreEmptySplits = BoxesRunTime.unboxToBoolean((Object)this.sparkContext().conf().get(package$.MODULE$.HADOOP_RDD_IGNORE_EMPTY_SPLITS()));
    }

    public HadoopRDD(SparkContext sc, JobConf conf, Class<? extends InputFormat<K, V>> inputFormatClass, Class<K> keyClass, Class<V> valueClass, int minPartitions) {
        this(sc, sc.broadcast(new SerializableConfiguration((Configuration)conf), ClassTag$.MODULE$.apply(SerializableConfiguration.class)), (Option<Function1<JobConf, BoxedUnit>>)None$.MODULE$, inputFormatClass, keyClass, valueClass, minPartitions);
    }

    public static class HadoopMapPartitionsWithSplitRDD<U, T>
    extends RDD<U> {
        private final Function2<InputSplit, Iterator<T>, Iterator<U>> f;
        private final ClassTag<T> evidence$3;
        private final Option<Partitioner> partitioner;

        @Override
        public Option<Partitioner> partitioner() {
            return this.partitioner;
        }

        @Override
        public Partition[] getPartitions() {
            return this.firstParent(this.evidence$3).partitions();
        }

        @Override
        public Iterator<U> compute(Partition split, TaskContext context) {
            HadoopPartition partition = (HadoopPartition)split;
            InputSplit inputSplit = partition.inputSplit().value();
            return (Iterator)this.f.apply((Object)inputSplit, this.firstParent(this.evidence$3).iterator(split, context));
        }

        public HadoopMapPartitionsWithSplitRDD(RDD<T> prev, Function2<InputSplit, Iterator<T>, Iterator<U>> f, boolean preservesPartitioning, ClassTag<U> evidence$2, ClassTag<T> evidence$3) {
            this.f = f;
            this.evidence$3 = evidence$3;
            super(prev, evidence$2);
            this.partitioner = preservesPartitioning ? this.firstParent(evidence$3).partitioner() : None$.MODULE$;
        }
    }
}

