/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.collect;

import com.splunk.collect.AbstractEventWriter;
import com.splunk.collect.AvroEventWriter;
import com.splunk.collect.EventWriter;
import com.splunk.collect.EventWriterFactory;
import com.splunk.collect.IndexProcessor;
import com.splunk.collect.IndexS2SListener;
import com.splunk.collect.ParquetEventWriter;
import com.splunk.collect.SeqFileEventWriter;
import com.splunk.io.FastBufferedInputStream;
import com.splunk.s2s.Channel;
import com.splunk.s2s.Event;
import com.splunk.s2s.S2SListener;
import com.splunk.s2s.StreamingS2S;
import com.splunk.s2s.TCPSignature;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.Logger;

public class S2STester {
    private static Logger gLogger = Logger.getLogger(S2STester.class);

    public static void runServer(int port, boolean parsed, Path basePath, String eventFormat) throws Exception {
        String k = "__s2s_control_msg";
        String v = "cap_response=success;cap_flush_key=true;idx_can_send_hb=true;v4=true;channel_limit=500;ack=false";
        ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
        DataOutputStream dos = new DataOutputStream(baos);
        dos.writeInt(1);
        dos.writeInt(k.length() + 1);
        dos.write(k.getBytes());
        dos.write(0);
        dos.writeInt(v.length() + 1);
        dos.write(v.getBytes());
        dos.write(0);
        dos.writeInt(0);
        dos.writeInt(5);
        dos.write("_raw".getBytes());
        dos.write(0);
        byte[] bytes = baos.toByteArray();
        ServerSocket serverSocket = new ServerSocket(port);
        serverSocket.setReceiveBufferSize(65536);
        Socket clientSocket = null;
        while ((clientSocket = serverSocket.accept()) != null) {
            gLogger.info((Object)("Got new connection: " + clientSocket));
            ConnectionHandler ch = new ConnectionHandler(clientSocket, parsed, bytes, basePath, eventFormat);
            ch.start();
        }
    }

    public static void testFile(String inputFileName, S2SListener listener) throws Exception {
        FileInputStream in = new FileInputStream(inputFileName);
        S2STester.testStream(in, listener);
    }

    private static void testStream(InputStream in, S2SListener listener) throws Exception {
        TCPSignature tcpSig = new TCPSignature();
        tcpSig.readFromS2SV4(in, null);
        gLogger.info((Object)tcpSig);
        gLogger.info((Object)Event.readOldS2SEvent(in, null));
        gLogger.info((Object)Event.readOldS2SEvent(in, null));
        StreamingS2S s2s = new StreamingS2S(tcpSig, new FastBufferedInputStream(in, 16384), listener);
        s2s.run();
    }

    public static void usage() {
        System.out.println("Usage: java S2STester <mode> <args>");
        System.out.println("Available output file formats: seq, avro and parquet");
        System.out.println("Available compression codecs: uncompressed, snappy, gzip, lzo");
        System.out.println("Available modes:");
        System.out.println(" file  - read s2s data from specified file");
        System.out.println("   args <input-file> <output-dir> <output-format> <compression-codec>");
        System.out.println(" server <port> [parsed <output-dir> <event-file-format>]? - listen on specified port for s2s and write to raw stream to stdout");
    }

    public static void main(String[] args) throws Exception {
        try {
            Configuration conf = new Configuration();
            String mode = args[0];
            if ("file".equals(mode)) {
                String inputFileName = args[1];
                Path outputDir = new Path(args[2]);
                String outputFileFormat = args[3];
                String codec = args[4];
                AbstractEventWriter ew = null;
                if ("seq".equals(outputFileFormat)) {
                    ew = new SeqFileEventWriter(conf, outputDir, "block_" + codec, false);
                } else if ("avro".equals(outputFileFormat)) {
                    ew = new AvroEventWriter(conf, outputDir, codec, false);
                } else if ("parquet".equals(outputFileFormat)) {
                    ew = new ParquetEventWriter(conf, outputDir, codec, false);
                } else {
                    throw new IllegalArgumentException("Invalid file format: " + args[0]);
                }
                S2STester.testFile(inputFileName, new S2SListern2EventWriter(ew));
            } else if ("server".equals(mode)) {
                int port = Integer.parseInt(args[1]);
                boolean parsed = args.length > 2 && "parsed".equals(args[2]);
                Path basePath = null;
                String eventFormat = null;
                if (parsed) {
                    basePath = new Path(args[3]);
                    eventFormat = args[4];
                }
                S2STester.runServer(port, parsed, basePath, eventFormat);
            } else {
                System.err.println("unknown mode=" + mode);
                S2STester.usage();
                System.exit(1);
            }
        }
        catch (Exception e) {
            gLogger.error((Object)e);
            S2STester.usage();
            System.exit(1);
        }
        System.out.println("S2STester is done!");
    }

    private static class S2SListern2EventWriter
    implements S2SListener {
        EventWriter _ew;

        public S2SListern2EventWriter(EventWriter ew) {
            this._ew = ew;
        }

        @Override
        public void begin() {
        }

        @Override
        public void finish() {
            IOUtils.closeQuietly((Closeable)this._ew);
        }

        @Override
        public void gotAck(long start, long end) {
        }

        @Override
        public void gotChannel(Channel c) {
        }

        @Override
        public void gotControlEvent(Event e) {
            try {
                this._ew.addEvent(e);
            }
            catch (IOException e1) {
                throw new RuntimeException(e1);
            }
        }

        @Override
        public void gotDropChannel(Channel c) {
            this._ew.gotDropChannel(c);
        }

        @Override
        public void gotEvent(Event e) {
            try {
                this._ew.addEvent(e);
            }
            catch (IOException e1) {
                throw new RuntimeException(e1);
            }
        }

        @Override
        public void gotTimezone(byte[] tzinfo) {
        }
    }

    public static class ConnectionHandler
    extends Thread {
        Socket _socket;
        boolean _parsed;
        byte[] _output;
        Path _basePath;
        IndexS2SListener _isl;
        String _ef;

        ConnectionHandler(Socket socket, boolean parsed, byte[] bytes, Path basePath, String eventFormat) {
            this._socket = socket;
            this._parsed = parsed;
            this._output = bytes;
            this._basePath = basePath;
            this._isl = new IndexS2SListener();
            this._ef = eventFormat;
        }

        @Override
        public void run() {
            try {
                this.runImpl();
            }
            catch (Exception exception) {
            }
            finally {
                try {
                    this._socket.close();
                    this._isl.finish();
                }
                catch (IOException iOException) {}
            }
        }

        public void runImpl() throws Exception {
            DataOutputStream out = new DataOutputStream(this._socket.getOutputStream());
            out.writeInt(this._output.length);
            out.write(this._output);
            out.flush();
            InputStream in = this._socket.getInputStream();
            if (this._parsed) {
                EventWriterFactory ewf = new EventWriterFactory(){

                    @Override
                    public EventWriter getHadoopEventWriter(Configuration conf, boolean raw, Path dir, String baseName) {
                        AbstractEventWriter result;
                        block6: {
                            result = null;
                            try {
                                if (raw) {
                                    result = new SeqFileEventWriter(conf, dir, "block_snappy", false);
                                    break block6;
                                }
                                if ("parquet".equals(ConnectionHandler.this._ef)) {
                                    result = new ParquetEventWriter(conf, dir, "snappy", false);
                                    break block6;
                                }
                                if ("seq".equals(ConnectionHandler.this._ef) || ConnectionHandler.this._ef == null) {
                                    result = new SeqFileEventWriter(conf, dir, "block_snappy", false);
                                    break block6;
                                }
                                if ("avro".equals(ConnectionHandler.this._ef)) {
                                    result = new AvroEventWriter(conf, dir, "snappy", false);
                                    break block6;
                                }
                                throw new IllegalArgumentException("Unknown event format=" + ConnectionHandler.this._ef);
                            }
                            catch (Exception e) {
                                gLogger.info((Object)"Error while creating EventWriter", (Throwable)e);
                            }
                        }
                        return result;
                    }

                    @Override
                    public EventWriter getKafkaEventWriter(Configuration conf, String key) {
                        return null;
                    }
                };
                this._isl.addIndex(new IndexProcessor(false, "default", new Configuration(), this._basePath, ewf, null, null));
                S2STester.testStream(in, this._isl);
            } else {
                IOUtils.copyLarge((InputStream)in, (OutputStream)System.out);
            }
        }
    }
}

