/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mr.cache.queues;

import com.splunk.mr.cache.CacheIndexer;
import com.splunk.mr.cache.integration.KeyPointer;
import java.io.Closeable;
import java.util.Comparator;
import java.util.Iterator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;

public class CloseableBlockingQueue<T>
implements Closeable {
    private final BlockingQueue<Object> queue;
    private boolean closed = false;
    private Runnable newItemListener;

    public CloseableBlockingQueue(BlockingQueue<Object> queue) {
        this.queue = queue;
    }

    public synchronized boolean offer(T e) {
        this.throwIfClosed(this);
        boolean offered = this.queue.offer(e);
        if (offered && this.newItemListener != null) {
            this.newItemListener.run();
            this.newItemListener = null;
        }
        return offered;
    }

    private void throwIfClosed(CloseableBlockingQueue<T> q) {
        if (q.closed) {
            throw new IllegalStateException("Cannot offer more objects on a closed queue");
        }
    }

    public T take() throws InterruptedException {
        if (this.queue.isEmpty() && this.closed) {
            return null;
        }
        Object taken = this.queue.take();
        if (taken instanceof Close) {
            this.queue.offer(new Close());
            this.setNewItemListener(null);
            return null;
        }
        return (T)taken;
    }

    @Override
    public void close() {
        this.closed = true;
        this.queue.offer(new Close());
    }

    public boolean hasNext() {
        return this.queue.peek() != null;
    }

    public boolean isEmpty() {
        return this.queue.isEmpty() || this.queue.peek() instanceof Close;
    }

    public void drainTo(CloseableBlockingQueue<T> other) {
        this.throwIfClosed(other);
        Iterator it = this.queue.iterator();
        while (it.hasNext()) {
            Object next = it.next();
            if (!(next instanceof Close)) {
                other.queue.offer(next);
            }
            it.remove();
        }
    }

    public int getSize() {
        return this.queue.size();
    }

    public boolean isFinished() {
        return this.isEmpty() && this.closed;
    }

    public void setNewItemListener(Runnable newItemListener) {
        if (!this.isFinished()) {
            this.newItemListener = newItemListener;
        }
    }

    public static <T> CloseableBlockingQueue<T> makePriorityBlockingQueue(int initialCapacity, final Comparator<T> comparator) {
        return new CloseableBlockingQueue<T>(new PriorityBlockingQueue<Object>(initialCapacity, new Comparator<Object>(){

            @Override
            public int compare(Object arg0, Object arg1) {
                if (arg0 instanceof Close) {
                    return 1;
                }
                if (arg1 instanceof Close) {
                    return -1;
                }
                return comparator.compare(arg0, arg1);
            }
        }));
    }

    public static <T> CloseableBlockingQueue<T> create() {
        return new CloseableBlockingQueue<T>(new LinkedBlockingQueue<Object>());
    }

    public static <T> CloseableBlockingQueue<T> create(int capacity) {
        return new CloseableBlockingQueue<T>(new LinkedBlockingQueue<Object>(capacity));
    }

    public static CloseableBlockingQueue<KeyPointer> createPointerQueue() {
        int initialCapacity = 63;
        return CloseableBlockingQueue.makePriorityBlockingQueue(initialCapacity, new Comparator<KeyPointer>(){
            final ResultPointerComparator pointerComparator = new ResultPointerComparator();

            @Override
            public int compare(KeyPointer o1, KeyPointer o2) {
                return this.pointerComparator.compare(o1.pathAndPointer.pointer, o2.pathAndPointer.pointer);
            }
        });
    }

    private static class ResultPointerComparator
    implements Comparator<CacheIndexer.ResultPointer> {
        private ResultPointerComparator() {
        }

        @Override
        public int compare(CacheIndexer.ResultPointer ptr0, CacheIndexer.ResultPointer ptr1) {
            long off1;
            long off0 = ptr0.getOffset();
            if (off0 < (off1 = ptr1.getOffset())) {
                return -1;
            }
            if (off0 > off1) {
                return 1;
            }
            return 0;
        }
    }

    private static class Close {
        private Close() {
        }
    }
}

