/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.journal;

import com.splunk.journal.PrimitiveLongList;
import com.splunk.journal.RawdataJournalReader;
import com.splunk.journal.RawdataMetaKeyItemType;
import com.splunk.util.DoubleWithSigFigsAndPrecision;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class FieldDecoder {
    private static final int PDMKD_RAW_OFFSETLEN_REPEAT_DBLQUOTE = 1;
    private static final int PDMKD_RAW_OFFSETLEN_REPEAT_SNGLQUOTE = 2;
    private static final int PDMKD_RAW_OFFSETLEN_CESCAPING = 3;
    private static final int PDMKD_RAW_OFFSETLEN_XMLESCAPING = 4;
    private static final int PDMKD_RAW_OFFSETLEN_XMLESCAPING_W_CDATA = 5;
    private static final int PDMKD_RAW_OFFSETLEN_URLESCAPING = 6;
    static Logger logger = Logger.getLogger(FieldDecoder.class);
    static final BigInteger TWO_TO_64TH_POWER = BigInteger.valueOf(1L).shiftLeft(64);
    ArrayList<String> hosts = new ArrayList();
    ArrayList<String> sources = new ArrayList();
    ArrayList<String> sourcetypes = new ArrayList();
    ArrayList<String> strings = new ArrayList();
    private int activeHost = -1;
    private int activeSource = -1;
    private int activeSourcetype = -1;
    private long activeTime = -1L;

    FieldDecoder() {
    }

    static Number makeUnsigned(long value) {
        if (value < 0L) {
            return BigInteger.valueOf(value).add(TWO_TO_64TH_POWER);
        }
        return value;
    }

    Map<String, Object> convertMetainfo(PrimitiveLongList pll, byte[] raw, byte[] estorage) {
        LinkedHashMap<String, Object> fields = new LinkedHashMap<String, Object>();
        int i = 0;
        while (i < pll.length()) {
            long combined = pll.get(i++);
            RawdataMetaKeyItemType type = RawdataMetaKeyItemType.getTypeFromCombined(combined);
            int key = RawdataMetaKeyItemType.getCodeFromCombined(combined);
            String name = this.strings.get(key - 1);
            Object value = null;
            switch (type) {
                case RMKI_TYPE_UNSIGNED: {
                    value = FieldDecoder.makeUnsigned(pll.get(i++));
                    break;
                }
                case RMKI_TYPE_STRING: {
                    int idx = (int)pll.get(i++) - 1;
                    value = this.strings.get(idx);
                    break;
                }
                case RMKI_TYPE_OFFSET_LEN: {
                    int length = (int)pll.get(i++);
                    int offset = (int)pll.get(i++);
                    value = new String(raw, offset, length, RawdataJournalReader.UTF_8);
                    break;
                }
                case RMKI_TYPE_OFFSET_LEN_WENCODING: {
                    int encoding = (int)pll.get(i++);
                    int length = (int)pll.get(i++);
                    int offset = (int)pll.get(i++);
                    value = new String(raw, offset, length, RawdataJournalReader.UTF_8);
                    break;
                }
                case RMKI_TYPE_SIGNED: {
                    value = pll.get(i++);
                    break;
                }
                default: {
                    int offset;
                    if (type.isFloatType()) {
                        boolean is64Bit = (combined & 8L) != 0L;
                        offset = (int)pll.get(i++);
                        int sigFigs = Integer.MAX_VALUE;
                        int precision = Integer.MAX_VALUE;
                        if ((combined & 1L) == 0L) {
                            sigFigs = (int)pll.get(i++);
                        }
                        if ((combined & 4L) == 0L) {
                            precision = (int)pll.get(i++);
                        }
                        if (is64Bit) {
                            long representation = this.parseFixedWidthNumber(64, estorage, offset);
                            value = new DoubleWithSigFigsAndPrecision(Double.longBitsToDouble(representation), sigFigs, precision);
                            break;
                        }
                        int represention = (int)this.parseFixedWidthNumber(32, estorage, offset);
                        value = new DoubleWithSigFigsAndPrecision(Float.intBitsToFloat(represention), sigFigs, precision);
                        break;
                    }
                    logger.warn((Object)("Unknown RawdataMetaKeyItemType value: " + (Object)((Object)type)));
                }
            }
            if (null == value) continue;
            fields.put(name, value);
        }
        return fields;
    }

    void addCode(byte opcode, byte[] value) {
        String valAsString = new String(value, RawdataJournalReader.UTF_8);
        ArrayList<String> list = null;
        switch (opcode) {
            case 3: {
                list = this.hosts;
                break;
            }
            case 4: {
                list = this.sources;
                break;
            }
            case 5: {
                list = this.sourcetypes;
                break;
            }
            case 6: {
                list = this.strings;
                break;
            }
            default: {
                throw new IllegalStateException("Trying to add a re-used string value with an illegal opcode. opcode=" + opcode + ", text=" + valAsString);
            }
        }
        list.add(valAsString);
    }

    void setActiveHost(int val) {
        this.activeHost = val;
    }

    void setActiveSource(int activeSource) {
        this.activeSource = activeSource;
    }

    void setActiveSourcetype(int activeSourcetype) {
        this.activeSourcetype = activeSourcetype;
    }

    void setActiveTime(long activeTime) {
        this.activeTime = activeTime;
    }

    String getHost() {
        return this.hosts.get(this.activeHost - 1);
    }

    String getSource() {
        return this.sources.get(this.activeSource - 1);
    }

    String getSourcetype() {
        return this.sourcetypes.get(this.activeSourcetype - 1);
    }

    long getTime() {
        return this.activeTime;
    }

    private long parseFixedWidthNumber(int numBits, byte[] data, int offset) {
        if (offset + numBits > data.length) {
            throw new IllegalStateException("Bad offset to floating point number");
        }
        long scratchPad = 0L;
        for (int shift = 0; shift < numBits; shift += 8) {
            byte datum = data[offset++];
            long byteAsLong = 0xFF & datum;
            scratchPad |= byteAsLong << shift;
        }
        return scratchPad;
    }
}

