/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.search;

import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class SearchResults {
    protected Map<String, Integer> keyMap = new LinkedHashMap<String, Integer>();
    protected int keyMapMaxIndex = 0;
    protected List<Result> results = new ArrayList<Result>(16);

    public void clear() {
        this.keyMap.clear();
        this.keyMapMaxIndex = 0;
        this.results.clear();
    }

    public Result addNewResult() {
        Result r = new Result(this);
        this.results.add(r);
        return r;
    }

    public int keyIndex(String name) {
        Integer r = this.keyMap.get(name);
        if (r == null) {
            r = this.keyMapMaxIndex;
            this.keyMap.put(name, this.keyMapMaxIndex++);
        }
        return r;
    }

    public int getIndex(String name) {
        Integer r = this.keyMap.get(name);
        return r == null ? -1 : r;
    }

    public Map<String, Integer> getKeyMap() {
        return Collections.unmodifiableMap(this.keyMap);
    }

    public Iterator<Result> iterator() {
        return this.results.iterator();
    }

    public int size() {
        return this.results.size();
    }

    public boolean isEmpty() {
        return this.results.isEmpty();
    }

    private static CharSequence csvEscape(String str, StringBuilder buf) {
        boolean needsEscaping;
        boolean hasQuotes = str.contains("\"");
        boolean bl = needsEscaping = hasQuotes || str.contains("\n") || str.contains(",");
        if (!needsEscaping) {
            return str;
        }
        buf.setLength(0);
        buf.append('\"');
        buf.append(hasQuotes ? str.replace("\"", "\"\"") : str);
        buf.append('\"');
        return buf;
    }

    public int fromCSV(InputStream in) {
        throw new UnsupportedOperationException("fromCSV not implemented yet");
    }

    public int toCSV(Writer out) throws IOException {
        if (this.isEmpty()) {
            return 0;
        }
        int result = 0;
        boolean first = true;
        StringBuilder buf = new StringBuilder(256);
        for (String s : this.keyMap.keySet()) {
            if (!first) {
                out.append(',');
            }
            out.append(SearchResults.csvEscape(s, buf));
            first = false;
        }
        out.append('\n');
        for (Result r : this.results) {
            boolean first2 = true;
            StringBuilder buf2 = new StringBuilder(256);
            for (Integer idx : this.keyMap.values()) {
                Object val;
                if (!first2) {
                    out.append(',');
                }
                if ((val = r.get(idx)) != null) {
                    out.append(SearchResults.csvEscape(String.valueOf(val), buf2));
                }
                first2 = false;
            }
            out.append('\n');
            ++result;
        }
        out.flush();
        return result;
    }

    public static class Result {
        protected SearchResults parent;
        protected ArrayList<Object> values;

        Result(SearchResults parent) {
            this.parent = parent;
            this.values = new ArrayList(8);
        }

        public Object set(int index, Object value) {
            while (this.values.size() < index + 1) {
                this.values.add(null);
            }
            return this.values.set(index, value);
        }

        public Object set(String name, Object value) {
            return this.set(this.parent.keyIndex(name), value);
        }

        public Object get(int index) {
            if (index < 0 || this.values.size() <= index) {
                return null;
            }
            return this.values.get(index);
        }

        public Object get(String name) {
            return this.get(this.parent.getIndex(name));
        }
    }
}

