/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.util;

import java.util.ArrayList;
import java.util.List;

public class FunctionUtils {
    public static <T, E> List<E> map(Iterable<T> in, Fn<T, E> fn) {
        ArrayList<E> list = new ArrayList<E>();
        for (T t : in) {
            try {
                list.add(fn.apply(t));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return list;
    }

    public static <T, E> E reduce(Iterable<T> in, E seed, RFn<T, E> reduceFn) {
        for (T t : in) {
            try {
                seed = reduceFn.apply(seed, t);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return seed;
    }

    public static <T> List<T> keep(Iterable<T> in, Predicate<T> predicate) {
        ArrayList<T> kept = new ArrayList<T>();
        for (T t : in) {
            if (!predicate.test(t)) continue;
            kept.add(t);
        }
        return kept;
    }

    public static interface Predicate<T> {
        public boolean test(T var1);
    }

    public static interface RFn<T, E> {
        public E apply(E var1, T var2) throws Exception;
    }

    public static interface Fn<T, E> {
        public E apply(T var1) throws Exception;
    }
}

