/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.datasource.hive;

import com.splunk.mr.SplunkMR;
import com.splunk.util.SecurityUtil;
import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.log4j.Logger;
import org.apache.thrift.TException;

public class HiveMetaStoreUtils {
    private static Map<String, IMetaStoreClient> clientCache = new ConcurrentHashMap<String, IMetaStoreClient>(4);
    private static Logger gLogger = Logger.getLogger(HiveMetaStoreUtils.class);

    public static IMetaStoreClient getHiveMetaStoreClient(Configuration conf) {
        String metaStoreUris = conf.get(HiveConf.ConfVars.METASTOREURIS.toString());
        if (metaStoreUris == null) {
            throw new RuntimeException("Failed to get Hive MetaStore Client, " + HiveConf.ConfVars.METASTOREURIS.toString() + " is missing!");
        }
        if (clientCache.containsKey(metaStoreUris)) {
            return clientCache.get(metaStoreUris);
        }
        SecurityUtil.ensureLogin(conf);
        final HiveConf hconf = new HiveConf(conf, HiveMetaStoreUtils.class);
        Object client = null;
        try {
            client = SplunkMR.useProxy((Configuration)hconf) ? (IMetaStoreClient)UserGroupInformation.getCurrentUser().getRealUser().doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<IMetaStoreClient>(){

                @Override
                public IMetaStoreClient run() throws Exception {
                    HiveMetaStoreClient client = new HiveMetaStoreClient(hconf);
                    return client;
                }
            }) : new HiveMetaStoreClient(hconf);
            clientCache.put(metaStoreUris, (IMetaStoreClient)client);
            return client;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get Hive MetaStore Client:", e);
        }
    }

    public static Table getTable(Configuration conf, String dbName, String tableName) {
        IMetaStoreClient client = HiveMetaStoreUtils.getHiveMetaStoreClient(conf);
        try {
            if (dbName == null) {
                dbName = "default";
            }
            return client.getTable(dbName, tableName);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get Hive metadata for table [" + tableName + "] and db [" + dbName + "]:" + e.getMessage(), e);
        }
    }

    public static HivePartitionInfo getPartitionInfo(Configuration conf, String dbName, String tableName) throws IOException, TException {
        IMetaStoreClient client = HiveMetaStoreUtils.getHiveMetaStoreClient(conf);
        List pNames = client.listPartitionNames(dbName, tableName, (short)1);
        if (pNames == null || pNames.isEmpty()) {
            gLogger.debug((Object)("No partition found. dbName=" + dbName + ", tableName=" + tableName));
            return null;
        }
        List partitions = client.getPartitionsByNames(dbName, tableName, pNames);
        if (partitions == null || partitions.isEmpty()) {
            gLogger.debug((Object)("No partition found. dbName=" + dbName + ", tableName=" + tableName));
            return null;
        }
        Partition p = (Partition)partitions.get(0);
        String location = p.getSd().getLocation();
        LinkedHashMap kvs = Warehouse.makeSpecFromName((String)((String)pNames.get(0)));
        HivePartitionInfo pi = new HivePartitionInfo(location, kvs);
        return pi;
    }

    public static class HivePartitionInfo {
        public final String location;
        public final LinkedHashMap<String, String> kvs;

        public HivePartitionInfo(String location, LinkedHashMap<String, String> kvs) {
            this.location = location;
            this.kvs = kvs;
        }
    }
}

