/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Map;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;

public class ChunkedOutputStream {
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private OutputStream _out = null;
    private ObjectMapper _jsonMapper = null;

    public ChunkedOutputStream(OutputStream out) {
        this._out = out;
        this._jsonMapper = new ObjectMapper();
    }

    public void write(Map<String, Object> header, String body) throws JsonGenerationException, JsonMappingException, IOException {
        if (header == null) {
            this.write((String)null, body);
        } else {
            this.write(this._jsonMapper.writeValueAsString(header), body);
        }
    }

    public void write(Map<String, Object> header, ByteArrayOutputStream body) throws JsonGenerationException, JsonMappingException, IOException {
        if (header == null) {
            this.write((String)null, body);
        } else {
            this.write(this._jsonMapper.writeValueAsString(header), body);
        }
    }

    public void write(String header, String body) throws IOException {
        byte[] h = header == null ? new byte[]{} : header.getBytes(UTF8);
        byte[] b = body == null ? new byte[]{} : body.getBytes(UTF8);
        this.write(h, 0, h.length, b, 0, b.length);
    }

    public void write(String header, ByteArrayOutputStream body) throws IOException {
        byte[] h = header == null ? new byte[]{} : header.getBytes(UTF8);
        this.write(h, 0, h.length, body);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] header, int hOff, int hLen, byte[] body, int bOff, int bLen) throws IOException {
        String chunked = String.format("chunked 1.0,%d,%d\n", header == null ? 0 : hLen, body == null ? 0 : bLen);
        byte[] c = chunked.getBytes(UTF8);
        OutputStream outputStream = this._out;
        synchronized (outputStream) {
            this._out.write(c, 0, c.length);
            if (header != null && hLen > 0) {
                this._out.write(header, hOff, hLen);
            }
            if (body != null && bLen > 0) {
                this._out.write(body, bOff, bLen);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] header, int hOff, int hLen, ByteArrayOutputStream body) throws IOException {
        String chunked = String.format("chunked 1.0,%d,%d\n", header == null ? 0 : hLen, body == null ? 0 : body.size());
        byte[] c = chunked.getBytes(UTF8);
        OutputStream outputStream = this._out;
        synchronized (outputStream) {
            this._out.write(c, 0, c.length);
            if (header != null && hLen > 0) {
                this._out.write(header, hOff, hLen);
            }
            if (body != null) {
                body.writeTo(this._out);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws IOException {
        OutputStream outputStream = this._out;
        synchronized (outputStream) {
            this._out.flush();
        }
    }

    public long copyAll(InputStream in, int bufferSize) throws IOException {
        byte[] buf = new byte[bufferSize];
        long count = 0L;
        int n = 0;
        while (-1 != (n = in.read(buf))) {
            this.write(null, 0, 0, buf, 0, n);
            count += (long)n;
        }
        return count;
    }
}

