/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mr;

import com.splunk.io.SearchOutputStream;
import com.splunk.mr.JobSubmitter;
import com.splunk.mr.ResultFileReader;
import com.splunk.mr.SplunkBaseMapper;
import com.splunk.mr.SplunkMR;
import com.splunk.mr.cache.JobQueue;
import com.splunk.mr.cache.MapCaches;
import com.splunk.mr.cache.integration.CacheEvent;
import com.splunk.mr.cache.integration.CacheSplitListener;
import com.splunk.mr.cache.queues.CloseableBlockingQueue;
import com.splunk.mr.input.ObjectAcceptor;
import com.splunk.mr.input.VixInputSplit;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.TaskCompletionEvent;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.log4j.Logger;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.map.JsonMappingException;

public class OutputProcessor
extends Thread
implements ObjectAcceptor<Object> {
    private static Logger gLogger = Logger.getLogger(OutputProcessor.class);
    protected long _maxStreamBytes = Integer.MIN_VALUE;
    protected long _streamBytes = 0L;
    protected SearchOutputStream _out = null;
    protected Configuration _conf = null;
    protected FileSystem _fs = null;
    protected ThreadPoolExecutor _tpe = null;
    protected MapCaches _mapCaches;
    protected CacheSplitListener _cacheSplitListener;
    protected volatile boolean _isStreaming = true;
    protected volatile boolean _isDone = false;
    protected Exception _err = null;
    protected LinkedBlockingQueue<VixInputSplit> _rawSplits = new LinkedBlockingQueue();
    protected LinkedBlockingQueue<JobSubmitter.CompletionEvent> _reports = new LinkedBlockingQueue();
    protected CloseableBlockingQueue<CacheEvent> _cachedResults = CloseableBlockingQueue.create();
    protected Set<String> _streamedSplits = Collections.newSetFromMap(new ConcurrentHashMap());
    protected boolean _cachePopulationMode = false;
    private LinkedHashSet<String> _processedSplits = new LinkedHashSet();
    private static final String PART_FILE_FORMAT = "part-%s-%05d";
    private static final int MAX_CACHE_READ_TRIES = 5;

    public OutputProcessor(FileSystem fs, SearchOutputStream out, Configuration conf, String mode, MapCaches mapCaches) {
        this._fs = fs;
        this._out = out;
        this._mapCaches = mapCaches;
        this._conf = new Configuration(conf);
        this._isStreaming = true;
        this._maxStreamBytes = this._conf.getLong(SplunkMR.CONF_MAX_STREAM, this._maxStreamBytes);
        if (mode.compareTo("report") == 0) {
            this._isStreaming = false;
        } else if (mode.compareTo("stream") == 0) {
            this._maxStreamBytes = 0L;
        }
        this.setDaemon(true);
        this.setName("OutputProcessor-" + mode);
        this._cachePopulationMode = SplunkMR.isCachePopulationSearch(conf);
    }

    public synchronized Exception getError() {
        return this._err;
    }

    public synchronized void setError(Exception ex) {
        this._err = ex;
        gLogger.error((Object)this._err.getMessage(), (Throwable)this._err);
        this._isDone = true;
    }

    public synchronized void waitForCompletion() throws InterruptedException {
        if (Thread.currentThread().equals(this)) {
            throw new RuntimeException("Cannot call waitForCompletion from within the OutputProcessor thread!");
        }
        while (!(this._isDone || this._cachedResults.isEmpty() && this._rawSplits.isEmpty() && this._reports.isEmpty())) {
            this.wait(1000L);
        }
        this._isDone = true;
        if (this._tpe != null) {
            this._tpe.shutdown();
            this._tpe.awaitTermination(1L, TimeUnit.HOURS);
        }
        this.join();
    }

    @Override
    public synchronized boolean accept(Object obj) {
        gLogger.debug((Object)("received: " + obj));
        if (this._isDone) {
            return false;
        }
        if (obj == null) {
            this._isDone = true;
            return false;
        }
        if (obj instanceof CacheEvent.NoMoreEvents) {
            this._cachedResults.close();
        }
        if (this._cachePopulationMode) {
            this._isStreaming = false;
            if (obj instanceof JobSubmitter.CompletionEvent) {
                this.removePartFile((JobSubmitter.CompletionEvent)obj);
            }
            this.notifyAll();
            return true;
        }
        if (obj instanceof CacheEvent) {
            this._cachedResults.offer((CacheEvent)obj);
            this._isStreaming = false;
            this.notifyAll();
        } else if (obj instanceof JobSubmitter.CompletionEvent) {
            JobSubmitter.CompletionEvent ce = (JobSubmitter.CompletionEvent)obj;
            if (ce.getTaskStatus() == TaskCompletionEvent.Status.SUCCEEDED) {
                this._reports.offer(ce);
                this._rawSplits.clear();
                this._isStreaming = false;
            }
            this.notifyAll();
        } else if (obj instanceof VixInputSplit) {
            if (this._isStreaming) {
                VixInputSplit split = (VixInputSplit)((Object)obj);
                if (this._maxStreamBytes <= 0L || this._maxStreamBytes > this._streamBytes) {
                    this._streamBytes += split.getLength();
                    this._rawSplits.offer(split);
                    this.notifyAll();
                } else {
                    gLogger.debug((Object)("ignoring split, max stream bytes reached, current=" + this._streamBytes + ", max=" + this._maxStreamBytes));
                }
            }
        } else if (obj instanceof CacheEvent.NoMoreEvents) {
            this.notifyAll();
        } else {
            gLogger.warn((Object)("cannot accept objects of class=" + obj.getClass().getName() + ", ignoring ..."));
        }
        return true;
    }

    @Override
    public void run() {
        try {
            this.outputStreaming();
            if (!this._isDone) {
                this.outputReports();
            }
            if (this._out.getStreamType().equals("")) {
                this._out.setStreamType(this._isStreaming ? "raw" : "report");
            }
            this._out.writeHeader();
        }
        catch (Exception e) {
            this.setError(e);
        }
        finally {
            this._isDone = true;
            this.awaitCacheReading();
            this.cleanup();
        }
    }

    protected void cleanup() {
        if (this._tpe != null && !this._tpe.isShutdown()) {
            this._tpe.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void outputStreaming() throws InterruptedException, IOException {
        boolean firstSplit = true;
        while (true) {
            VixInputSplit vixSplit = null;
            OutputProcessor outputProcessor = this;
            synchronized (outputProcessor) {
                if (!this._isStreaming || this._isDone) {
                    break;
                }
                while (this._rawSplits.isEmpty() && this._isStreaming && !this._isDone) {
                    this.wait(500L);
                }
                if (this._rawSplits.isEmpty()) {
                    return;
                }
                vixSplit = this._rawSplits.poll();
            }
            try {
                if (firstSplit) {
                    this._out.addMetric("stream.delay", System.currentTimeMillis() - SplunkMR.START_TIME, 1L);
                }
                if (!vixSplit.isDmaSplit()) {
                    SplunkBaseMapper.stream(this._out, vixSplit, this._conf, new TaskAttemptID());
                    this._streamedSplits.add(vixSplit.getSplitId());
                }
            }
            catch (IOException e) {
                gLogger.warn((Object)("IOException while processing split, will continue... split=" + vixSplit.toString() + ", message=" + e.getMessage()));
            }
            firstSplit = false;
        }
        this._rawSplits.clear();
        gLogger.info((Object)"Done streaming");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void outputReports() throws JsonGenerationException, JsonMappingException, IOException, InterruptedException {
        gLogger.info((Object)"setting output to mode=\"report\"");
        boolean firstReport = true;
        boolean firstCache = true;
        boolean hasWaitedForCacheResults = false;
        this._tpe = this.initThreadPoolExecutor();
        while (true) {
            OutputProcessor outputProcessor = this;
            synchronized (outputProcessor) {
                if (this._isDone) {
                    break;
                }
            }
            long start = System.currentTimeMillis();
            boolean waitMore = true;
            while (waitMore) {
                OutputProcessor outputProcessor2 = this;
                synchronized (outputProcessor2) {
                    waitMore = this._cachedResults.isEmpty() && this._reports.isEmpty() && !this._isDone;
                }
                boolean noMoreCacheEventsToSubmit = this._cachedResults.isFinished();
                if (noMoreCacheEventsToSubmit && !hasWaitedForCacheResults) {
                    hasWaitedForCacheResults = true;
                    this.awaitCacheReadingAsync();
                }
                if (!waitMore) continue;
                Thread.sleep(500L);
            }
            long elapsed = System.currentTimeMillis() - start;
            if (elapsed > 0L) {
                this._out.addMetric("report.wait", elapsed, 1L);
            }
            OutputProcessor outputProcessor3 = this;
            synchronized (outputProcessor3) {
                if (this._cachedResults.isFinished() && this._reports.isEmpty()) {
                    return;
                }
            }
            if (!this._cachedResults.isEmpty()) {
                if (firstCache) {
                    this._out.addMetric("cache.delay", System.currentTimeMillis() - SplunkMR.START_TIME, 1L);
                }
                firstCache = false;
                CacheEvent ce = this._cachedResults.take();
                if (ce == null) continue;
                this.outputCachedResult(ce);
                continue;
            }
            if (firstReport) {
                this._out.addMetric("report.delay", System.currentTimeMillis() - SplunkMR.START_TIME, 1L);
            }
            firstReport = false;
            outputProcessor3 = this;
            synchronized (outputProcessor3) {
                JobSubmitter.CompletionEvent ce = this._reports.poll();
                if (ce != null && !this._isDone) {
                    this.outputReportCompletionEvent(ce);
                }
            }
        }
    }

    private void awaitCacheReadingAsync() {
        if (!this._tpe.isShutdown()) {
            this._tpe.execute(new Runnable(){

                @Override
                public void run() {
                    OutputProcessor.this.awaitCacheReading();
                }
            });
        }
    }

    private void awaitCacheReading() {
        try {
            this._mapCaches.awaitCacheReading();
        }
        finally {
            this._cacheSplitListener.doneCacheReading();
        }
    }

    private ThreadPoolExecutor initThreadPoolExecutor() {
        int threads = OutputProcessor.getThreadCount(this._conf);
        return new ThreadPoolExecutor(Math.max(1, threads / 2), threads, 100L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
    }

    public static int getThreadCount(Configuration conf) {
        int threads = conf.getInt(SplunkMR.CONF_COLLECT_THREADS, 10);
        threads = threads < 1 ? 1 : threads;
        threads = threads > 50 ? 50 : threads;
        return threads;
    }

    protected synchronized void outputReportCompletionEvent(JobSubmitter.CompletionEvent ce) throws IOException {
        Path file = this.getFile(ce);
        gLogger.debug((Object)("processing report file=" + file));
        if (this._fs.exists(file)) {
            ResultFileReader rfr = ResultFileReader.create(this._fs, file, this._out, this._streamedSplits, "report");
            rfr.setRemoveResultFile(true);
            rfr.setProcessedSplits(this._processedSplits);
            this._tpe.execute(new OutputJob(this, rfr));
            this.removePartFile(ce);
        } else {
            this._reports.offer(ce);
        }
    }

    private void removePartFile(JobSubmitter.CompletionEvent ce) {
        Path partFile = new Path(this.getFile(ce).getParent(), String.format(PART_FILE_FORMAT, ce.getFileType(), ce.getTaskId()));
        try {
            this._fs.delete(partFile, false);
        }
        catch (Exception ignore) {
            gLogger.warn((Object)("Failed to delete part file: path=" + partFile + ", message=" + ignore.getMessage()));
        }
    }

    private Path getFile(JobSubmitter.CompletionEvent ce) {
        return new Path(SplunkMR.getHDFSDispatchHome(ce.getConfiguration()), SplunkMR.getJobFilename(ce.getFileType(), ce.getTaskId()));
    }

    private void outputCachedResult(CacheEvent ce) throws IOException {
        this.outputCachedResult(ce, 0);
    }

    private void outputCachedResult(final CacheEvent ce, int tries) throws IOException {
        if (tries >= 5) {
            this._cacheSplitListener.onCacheReadFailure(ce.getCacheKey());
            return;
        }
        if (ce.isCompacted()) {
            try {
                this._mapCaches.fetchCompactedResult(ce.getCacheKey(), this._out, this._tpe, this._cacheSplitListener);
            }
            catch (Exception e) {
                gLogger.error((Object)"Exception when reading compacted cache result", (Throwable)e);
                this._mapCaches.flagCacheUpdate(ce.getCacheKey());
                this.outputCachedResult(ce, tries + 1);
            }
        } else {
            JobQueue.CacheJob stagedResult = this._mapCaches.getStagedResult(ce.getCacheKey());
            final ResultFileReader rfr = ResultFileReader.create(stagedResult, this._out, this._streamedSplits);
            this._tpe.execute(new OutputJob(this, new Runnable(){

                @Override
                public void run() {
                    try {
                        rfr.run();
                    }
                    catch (Exception e) {
                        gLogger.error((Object)"Exception reading staged cache result", (Throwable)e);
                        OutputProcessor.this._mapCaches.flagCacheUpdate(ce.getCacheKey());
                        OutputProcessor.this.accept(CacheEvent.newCompacted(ce.getCacheKey()));
                    }
                }
            }));
        }
    }

    public void setCacheSplitListener(CacheSplitListener cacheSplitListener) {
        this._cacheSplitListener = cacheSplitListener;
    }

    protected static class OutputJob
    implements Runnable {
        protected OutputProcessor _op = null;
        protected Runnable _worker = null;

        public OutputJob(OutputProcessor op, Runnable worker) {
            this._op = op;
            this._worker = worker;
        }

        @Override
        public void run() {
            try {
                this._worker.run();
            }
            catch (Exception e) {
                this._op.setError(e);
            }
        }
    }
}

