/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.util;

import com.splunk.util.StrUtil;
import com.splunk.util.Tuple;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.Logger;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.ObjectCodec;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.util.TokenBuffer;

public class JsonUtil {
    private static final Logger gLogger = Logger.getLogger(JsonUtil.class);
    private static final Pattern commaSeparatorPattern = Pattern.compile(" *, *");

    public static String getString(JsonNode node, String key) {
        String val = null;
        JsonNode subnode = node.path(key);
        if (null != subnode && !subnode.isMissingNode() && null != (val = subnode.getTextValue())) {
            val = val.trim();
        }
        return val;
    }

    public static String getString(JsonNode node, String key, String defaultVal) {
        String val = JsonUtil.getString(node, key);
        return null == val ? defaultVal : val;
    }

    public static String[] getCommaSeparatedStringList(JsonNode node, String key) {
        String raw = JsonUtil.getString(node, key);
        if (null == raw) {
            return new String[0];
        }
        return commaSeparatorPattern.split(raw);
    }

    public static boolean getBoolean(JsonNode node, String key, boolean defaultVal) {
        String val = JsonUtil.getString(node, key);
        return StrUtil.parseBoolean(val, defaultVal);
    }

    public static Path getPath(JsonNode node, String key, FileSystem fs) throws IOException {
        String raw = node.path(key).getTextValue().trim();
        Path p = new Path(raw);
        return fs.makeQualified(p);
    }

    public static int getInt(JsonNode node, String key) {
        String raw = node.path(key).getTextValue();
        return Integer.parseInt(raw);
    }

    public static int getPositiveInt(JsonNode node, String key, int defaultVal) {
        JsonNode subnode = node.path(key);
        if (subnode.isMissingNode()) {
            return defaultVal;
        }
        int val = Integer.parseInt(subnode.getTextValue());
        if (val > 0) {
            gLogger.warn((Object)("Value of " + key + " must be positive. Ignoring value of " + val + " in favor of default value " + defaultVal));
            return val;
        }
        return defaultVal;
    }

    public static int getNonnegativeInt(JsonNode node, String key, int defaultVal) {
        String raw = node.path(key).getTextValue();
        if (null == raw) {
            return defaultVal;
        }
        int val = Integer.parseInt(raw);
        if (val < 0) {
            gLogger.warn((Object)("Value of " + key + " must be non-negative. Ignoring value of " + val + " in favor of default value " + defaultVal));
            return defaultVal;
        }
        return val;
    }

    public static long getPositiveLong(JsonNode node, String key, long defaultVal) {
        String raw = node.path(key).getTextValue();
        if (null == raw) {
            return defaultVal;
        }
        long val = Long.parseLong(raw);
        if (val <= 0L) {
            gLogger.warn((Object)("Value of " + key + " must be positive. Ignoring value of " + val + " in favor of default value " + defaultVal));
            return defaultVal;
        }
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JsonNode valueToTree(ObjectMapper objectMapper, Object value) throws IOException {
        if (value == null) {
            return null;
        }
        TokenBuffer tokenBuffer = new TokenBuffer((ObjectCodec)objectMapper);
        try {
            objectMapper.writeValue((JsonGenerator)tokenBuffer, value);
            JsonNode jsonNode = objectMapper.readTree(tokenBuffer.asParser());
            return jsonNode;
        }
        finally {
            IOUtils.closeQuietly((Closeable)tokenBuffer);
        }
    }

    public static List<Tuple<String, JsonNode>> getFields(JsonNode node) {
        ArrayList<Tuple<String, JsonNode>> fields = new ArrayList<Tuple<String, JsonNode>>();
        Iterator fieldNames = node.getFieldNames();
        while (fieldNames.hasNext()) {
            String fieldName = (String)fieldNames.next();
            fields.add(new Tuple<String, JsonNode>(fieldName, node.get(fieldName)));
        }
        return fields;
    }

    public static boolean has(JsonNode node, String fieldName) {
        return node.get(fieldName) != null;
    }
}

