/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.util;

import com.splunk.mr.SplunkMR;
import java.io.File;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.log4j.Logger;

public class SecurityUtil {
    private static Logger gLogger = Logger.getLogger(SecurityUtil.class);
    private static boolean loggedIn = false;

    public static void ensureLogin(Configuration conf) throws IllegalArgumentException {
        if (loggedIn) {
            return;
        }
        if ("kerberos".equals(conf.get("hadoop.security.authentication"))) {
            if (conf.get(SplunkMR.CONF_KERBEROS_CONFFILE) != null && !new File(String.valueOf(conf.get(SplunkMR.CONF_KERBEROS_CONFFILE))).exists()) {
                throw new IllegalArgumentException("File is not found: " + conf.get(SplunkMR.CONF_KERBEROS_CONFFILE));
            }
            if (conf.get(SplunkMR.CONF_KERBEROS_KEYTAB) != null && !new File(String.valueOf(conf.get(SplunkMR.CONF_KERBEROS_KEYTAB))).exists()) {
                throw new IllegalArgumentException("File is not found: " + conf.get(SplunkMR.CONF_KERBEROS_KEYTAB));
            }
            try {
                UserGroupInformation.setConfiguration((Configuration)conf);
                UserGroupInformation.loginUserFromKeytab((String)String.valueOf(conf.get(SplunkMR.CONF_KERBEROS_PRINCIPAL)), (String)String.valueOf(conf.get(SplunkMR.CONF_KERBEROS_KEYTAB)));
            }
            catch (Exception e) {
                gLogger.error((Object)"Failed to login using keytab.", (Throwable)e);
                throw new IllegalArgumentException("Failed to login using keytab, please ensure " + SplunkMR.CONF_KERBEROS_PRINCIPAL + " and " + SplunkMR.CONF_KERBEROS_KEYTAB + " are set correctly. And either set both " + SplunkMR.CONF_JAVA_SYSTEM_PROPERTIES_PREFIX + SplunkMR.CONF_KERBEROS_KDC + " and " + SplunkMR.CONF_JAVA_SYSTEM_PROPERTIES_PREFIX + SplunkMR.CONF_KERBEROS_REALM + " or " + SplunkMR.CONF_JAVA_SYSTEM_PROPERTIES_PREFIX + SplunkMR.CONF_KERBEROS_CONFFILE + " alone, but not all three together: " + e.getMessage());
            }
        }
        loggedIn = true;
    }
}

