/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mr.input;

import com.splunk.collect.IndexProcessor;
import com.splunk.mr.input.BaseAvroRecordReader;
import com.splunk.mr.input.VixInputSplit;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.avro.hadoop.io.AvroKeyValue;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.log4j.Logger;
import org.codehaus.jackson.map.ObjectMapper;

public class ValueAvroRecordReader
extends BaseAvroRecordReader {
    private String dataFormat = "json";
    private Map<Object, Object> jsonResult;
    private ObjectMapper om;
    private static Logger gLogger = Logger.getLogger(ValueAvroRecordReader.class);

    @Override
    public boolean nextKeyValue() throws IOException {
        if (!super.nextKeyValue()) {
            return false;
        }
        AvroKeyValue kv = new AvroKeyValue(this.buffer);
        if (kv.getValue() != null && kv.getKey() != null) {
            this._val.set(String.valueOf(this.processEvent(kv.getValue())));
        } else {
            this._val.set(String.valueOf(this.processEvent(this.buffer.toString())));
        }
        return true;
    }

    private String getValue(Object datum) {
        if (null == datum) {
            return null;
        }
        if (datum instanceof ByteBuffer) {
            StringBuilder sb = new StringBuilder();
            ByteBuffer bytes = (ByteBuffer)datum;
            for (int i = bytes.position(); i < bytes.limit(); ++i) {
                sb.append((char)bytes.get(i));
            }
            return sb.toString();
        }
        return datum.toString();
    }

    @Override
    public void vixInitialize(VixInputSplit fileSplit, TaskAttemptContext context) throws IOException, InterruptedException {
        super.vixInitialize(fileSplit, context);
        if (IndexProcessor.isHunkEventFile(fileSplit.getPath())) {
            this.dataFormat = "json_events";
        }
    }

    @Override
    public String getOutputDataFormat() {
        return this.dataFormat;
    }
}

