/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.ast;

import com.splunk.commons.ast.nodes.Expression;
import com.splunk.commons.ast.nodes.IPredicate;
import com.splunk.commons.ast.nodes.ISearchPredicate;
import com.splunk.commons.ast.nodes.IWherePredicate;
import com.splunk.commons.ast.nodes.Node;
import com.splunk.commons.ast.nodes.PredicateType;
import com.splunk.commons.ast.nodes.expressions.AndNode;
import com.splunk.commons.ast.nodes.expressions.ComparisonNode;
import com.splunk.commons.ast.nodes.expressions.FieldNode;
import com.splunk.commons.ast.nodes.expressions.Operator;
import com.splunk.commons.ast.nodes.expressions.OrNode;
import com.splunk.commons.ast.nodes.expressions.StringNode;
import com.splunk.commons.ast.nodes.expressions.TypeNode;
import com.splunk.commons.ast.nodes.search.SearchAndNode;
import com.splunk.commons.ast.nodes.search.SearchComparisonNode;
import com.splunk.commons.datasets.BaseDataset;
import com.splunk.commons.datasets.Dataset;
import com.splunk.commons.datasets.IDatasetInfo;
import com.splunk.commons.datasets.IDatasetResolver;
import com.splunk.commons.datasets.ImportDataset;
import com.splunk.commons.visitors.NodeVisitor;
import com.splunk.commons.visitors.SplFormatter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Modules {
    public static final String MODULE_DEFAULT = "";
    public static final String MODULE_SEPARATOR = ".";
    public static final String MODULE_SEPARATOR_INDEXES = "_____";
    public static final String PROPERTY_ORIGINAL_DATASETID = "originalDatasetId";
    private static final Logger logger = LoggerFactory.getLogger(Modules.class);

    private Modules() {
    }

    public static Dataset getModuleQualifiedDataset(IDatasetResolver resolver, Dataset dataset) {
        IDatasetInfo datasetInfo = Modules.resolveRecursive(resolver, dataset);
        if (datasetInfo == null) {
            logger.warn("couldn't resolve dataset: " + dataset + " from backing resolver.");
            return dataset;
        }
        logger.debug("resolved dataset: " + String.format(". module=\"$1\", name=\"$2\", kind=\"$3\"", datasetInfo.getModule(), datasetInfo.getName(), datasetInfo.getKind()));
        return new Dataset(datasetInfo.getModule(), datasetInfo.getKind(), datasetInfo.getName());
    }

    public static IDatasetInfo resolveRecursive(IDatasetResolver resolver, Dataset dataset) {
        Dataset tobeResolved = dataset;
        while (true) {
            IDatasetInfo datasetInfo;
            if ((datasetInfo = resolver.resolveDataset(tobeResolved)) == null) {
                logger.warn("couldn't resolve dataset: " + dataset + " from backing resolver.");
                return datasetInfo;
            }
            if (!(datasetInfo instanceof BaseDataset)) {
                logger.warn("resolved datasetinfo for dataset: " + dataset + " from backing resolver is not valid. There must be some issue with caching.");
                return datasetInfo;
            }
            if (!(datasetInfo instanceof ImportDataset)) {
                return datasetInfo;
            }
            logger.debug("resolved dataset: " + String.format(". module=\"$1\", name=\"$2\", kind=\"$3\"", datasetInfo.getModule(), datasetInfo.getName(), datasetInfo.getKind()));
            tobeResolved = new Dataset(((ImportDataset)datasetInfo).getSourceModule() + MODULE_SEPARATOR + ((ImportDataset)datasetInfo).getSourceName());
        }
    }

    public static IWherePredicate buildWherePredicate(Iterable<Dataset> datasets, String module) {
        IWherePredicate predicate = null;
        for (Dataset dataset : datasets) {
            IWherePredicate dsPredicate = Expression.equal("module", !dataset.getModule().equals(MODULE_DEFAULT) ? dataset.getModule() : module);
            if (!dataset.getName().equals("*")) {
                dsPredicate = (IWherePredicate)dsPredicate.and(Expression.equal("name", dataset.getName()));
            }
            if (!dataset.getKind().equals("unknown")) {
                dsPredicate = (IWherePredicate)dsPredicate.and(Expression.equal("kind", dataset.getKind()));
            }
            predicate = predicate == null ? dsPredicate : (IWherePredicate)predicate.or(dsPredicate);
        }
        return predicate;
    }

    public static Set<Dataset> deconstructWherePredicate(IWherePredicate predicate) {
        Set<Dataset> datasetList = new HashSet<Dataset>();
        if (predicate == null) {
            return datasetList;
        }
        try {
            datasetList = predicate.getNode().accept(new PredicateDeconstructor());
        }
        catch (RuntimeException ex) {
            logger.warn("exception received while deconstructing predicate: " + predicate.getNode().accept(new SplFormatter()) + ". exception: " + ex.getMessage());
        }
        return datasetList;
    }

    public static IPredicate resolveWildcardedIndexes(IDatasetResolver resolver, Dataset dataset, PredicateType type) {
        List<IDatasetInfo> datasetInfoList = resolver.query(Modules.buildWherePredicate(Arrays.asList(dataset), resolver.getModule()));
        IPredicate resPredicate = null;
        for (IDatasetInfo datasetInfo : datasetInfoList) {
            if (!datasetInfo.getKind().equals(dataset.getKind())) continue;
            TypeNode predicate = type.equals((Object)PredicateType.SEARCH) ? new SearchComparisonNode(Operator.EQUAL, Expression.field("index"), new StringNode(Modules.moduleQualifiedName(datasetInfo.getModule(), datasetInfo.getKind(), datasetInfo.getName()))) : new ComparisonNode(Operator.EQUAL, Expression.field("index"), new StringNode(Modules.moduleQualifiedName(datasetInfo.getModule(), datasetInfo.getKind(), datasetInfo.getName())));
            resPredicate = resPredicate == null ? predicate : resPredicate.or((IPredicate)((Object)predicate));
        }
        if (resPredicate == null) {
            logger.warn("querying dataset: " + dataset + " resulted in no results.");
            return null;
        }
        return resPredicate.and((IPredicate)((Object)(type.equals((Object)PredicateType.SEARCH) ? new SearchAndNode(new ISearchPredicate[0]) : new AndNode(new IWherePredicate[0]))));
    }

    public static String moduleQualifiedName(String module, String kind, String name) {
        if (module.equals(MODULE_DEFAULT)) {
            return name;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(module);
        if (kind != null && (kind.equals("index") || kind.equals("metric"))) {
            builder.append(MODULE_SEPARATOR_INDEXES);
        } else {
            builder.append(MODULE_SEPARATOR);
        }
        return builder.append(name).toString();
    }

    private static final class PredicateDeconstructor
    extends NodeVisitor<Set<Dataset>> {
        private PredicateDeconstructor() {
        }

        @Override
        public Set<Dataset> visit(Node node) {
            return Collections.emptySet();
        }

        @Override
        public Set<Dataset> visit(AndNode node) {
            String kind = "unknown";
            String name = "*";
            String module = Modules.MODULE_DEFAULT;
            HashSet<Dataset> datasets = new HashSet<Dataset>();
            if (node.getArguments().size() < 2) {
                throw new IllegalArgumentException("Invalid AND node for predicate deconstruction");
            }
            for (int i = 0; i < node.getArguments().size(); ++i) {
                if (!(node.getArguments().get(i) instanceof ComparisonNode)) {
                    throw new IllegalArgumentException("Invalid AND node for predicate deconstruction");
                }
                ComparisonNode comparisonNode = (ComparisonNode)node.getArguments().get(i);
                if (!comparisonNode.getOperator().equals((Object)Operator.EQUAL) && !comparisonNode.getOperator().equals((Object)Operator.EQUAL_EQUAL)) {
                    throw new IllegalArgumentException("Invalid operator in comparison node: " + (Object)((Object)comparisonNode.getOperator()));
                }
                if (!(comparisonNode.getRhs() instanceof StringNode)) {
                    throw new IllegalArgumentException("Invalid rhs in comparison node - expected: string, got: " + comparisonNode.getRhs().getType());
                }
                if (!(comparisonNode.getLhs() instanceof FieldNode)) {
                    throw new IllegalArgumentException("Invalid lhs in comparison node - expected: field, got: " + comparisonNode.getLhs().getType());
                }
                FieldNode lhs = (FieldNode)comparisonNode.getLhs();
                String rhsVal = ((StringNode)comparisonNode.getRhs()).getValue();
                if (lhs.getFieldName().equals("kind")) {
                    kind = rhsVal;
                    continue;
                }
                if (lhs.getFieldName().equals("name")) {
                    name = rhsVal;
                    continue;
                }
                if (lhs.getFieldName().equals("module")) {
                    module = rhsVal;
                    continue;
                }
                throw new IllegalArgumentException("Invalid field name in comparison node - expected \"kind\" or \"name\" or \"module\"");
            }
            datasets.add(new Dataset(module, kind, name));
            return datasets;
        }

        @Override
        public Set<Dataset> visit(OrNode node) {
            HashSet<Dataset> datasets = new HashSet<Dataset>();
            for (int i = 0; i < node.getArguments().size(); ++i) {
                assert (node.getArguments().get(i) instanceof AndNode);
                datasets.addAll((Collection<Dataset>)((AndNode)node.getArguments().get(i)).getNode().accept(this));
            }
            return datasets;
        }
    }
}

