/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.ast.antlr;

import com.splunk.commons.ast.nodes.Node;
import com.splunk.commons.ast.nodes.commands.LookupCommand;
import com.splunk.commons.ast.nodes.commands.SearchCommand;
import com.splunk.commons.ast.nodes.expressions.JoinNode;
import com.splunk.spl.parser.SplunkCommandParser;
import com.splunk.spl.parser.SplunkCommandParserBaseVisitor;
import java.util.ArrayList;
import org.antlr.v4.runtime.tree.ParseTree;

public class CommandLookupVisitor
extends SplunkCommandParserBaseVisitor<Node> {
    private LookupCommand.LookupMode mode = LookupCommand.LookupMode.ALL;
    private JoinNode[] joinKeys;
    private JoinNode[] selections;

    @Override
    public Node visitLookupParse(SplunkCommandParser.LookupParseContext ctx) {
        String lookupTableName = ctx.lookupTableName().getText();
        this.visit((ParseTree)ctx.lookupArgs());
        return new LookupCommand(new SearchCommand(), lookupTableName, this.joinKeys, this.mode, this.selections);
    }

    private void parseAndSetMode(String modeString) {
        switch (modeString.toUpperCase()) {
            case "OUTPUT": {
                this.mode = LookupCommand.LookupMode.OUTPUT;
                break;
            }
            case "OUTPUTNEW": {
                this.mode = LookupCommand.LookupMode.OUTPUTNEW;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized mode for LOOKUP command:'" + modeString + "' allowed modes OUTPUT/OUTPUTNEW");
            }
        }
    }

    @Override
    public Node visitLookupArgs(SplunkCommandParser.LookupArgsContext ctx) {
        if (ctx.lookupMode != null) {
            this.parseAndSetMode(ctx.lookupMode.getText());
        }
        ArrayList<JoinNode> joinNodeList = new ArrayList<JoinNode>();
        for (SplunkCommandParser.LookupField2EventContext field2EventContext : ctx.lookupInputFields.lookupField2Event()) {
            joinNodeList.add((JoinNode)this.visit((ParseTree)field2EventContext));
        }
        this.joinKeys = new JoinNode[joinNodeList.size()];
        joinNodeList.toArray(this.joinKeys);
        if (ctx.lookupOutputFields == null) {
            return null;
        }
        joinNodeList.clear();
        for (SplunkCommandParser.LookupField2EventContext field2EventContext : ctx.lookupOutputFields.lookupField2Event()) {
            joinNodeList.add((JoinNode)this.visit((ParseTree)field2EventContext));
        }
        this.selections = new JoinNode[joinNodeList.size()];
        joinNodeList.toArray(this.selections);
        return null;
    }

    @Override
    public Node visitLookupField2Event(SplunkCommandParser.LookupField2EventContext ctx) {
        String lhsField = ctx.lookupField.getText();
        if (ctx.eventField != null) {
            String rhsField = ctx.eventField.getText();
            return new JoinNode(lhsField, rhsField);
        }
        return new JoinNode(lhsField);
    }
}

