/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.util;

import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyUtil {
    private static PropertyUtil instance;
    private static final Logger logger;
    private final Properties props;
    private final Map<String, String> env;

    public static PropertyUtil getInstance() {
        if (instance == null) {
            instance = new PropertyUtil(System.getenv());
        }
        return instance;
    }

    private PropertyUtil(Map<String, String> environment) {
        String configFile = "config.properties";
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        this.props = new Properties();
        this.env = environment;
        try {
            InputStream stream = loader.getResourceAsStream(configFile);
            this.props.load(stream);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getProperty(String key) {
        String value = this.env.get(PropertyUtil.convertToEnvName(key));
        if (value == null) {
            value = this.props.getProperty(key);
        }
        logger.debug(String.format("key=%s value=%s", key, value));
        return value;
    }

    private static String convertToEnvName(String key) {
        return key.replace('.', '_').toUpperCase();
    }

    static {
        logger = LoggerFactory.getLogger(PropertyUtil.class);
    }
}

