/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.visitors;

import com.splunk.commons.ast.Modules;
import com.splunk.commons.ast.SPLParseException;
import com.splunk.commons.ast.antlr.CompleteSPLParser;
import com.splunk.commons.ast.nodes.CommandNode;
import com.splunk.commons.ast.nodes.Node;
import com.splunk.commons.ast.nodes.commands.BinCommand;
import com.splunk.commons.ast.nodes.commands.FromCommand;
import com.splunk.commons.ast.nodes.commands.JoinCommand;
import com.splunk.commons.ast.nodes.commands.SavedsearchCommand;
import com.splunk.commons.ast.nodes.commands.StatsCommand;
import com.splunk.commons.ast.nodes.expressions.BinNode;
import com.splunk.commons.ast.nodes.search.IGroupBy;
import com.splunk.commons.datasets.IDatasetInfo;
import com.splunk.commons.datasets.IDatasetResolver;
import com.splunk.commons.providers.CompensatingFromProvider;
import com.splunk.commons.visitors.CommandRebuilder;
import java.io.IOException;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Expander
extends CommandRebuilder {
    private static final Logger logger = LoggerFactory.getLogger(Expander.class);
    private final IDatasetResolver datasetResolver;

    public Expander(IDatasetResolver datasetResolver) {
        this.datasetResolver = datasetResolver;
    }

    @Override
    public CommandNode visit(FromCommand node) {
        try {
            CompensatingFromProvider provider = new CompensatingFromProvider(this.datasetResolver);
            provider.initialize(node.getDataset());
            provider.where(node.getWhere());
            provider.groupBy(node.getGroupBy());
            provider.select(node.getSelections());
            provider.orderBy(node.getOrderings());
            CommandNode expandedFrom = provider.getCommand();
            return expandedFrom.accept(this);
        }
        catch (IOException ioe) {
            logger.warn("Failed to expand FromCommand: node={}", (Object)node);
            throw new RuntimeException(ioe.getMessage());
        }
    }

    @Override
    public CommandNode visit(SavedsearchCommand node) {
        Node parsed;
        IDatasetInfo resolved = Modules.resolveRecursive(this.datasetResolver, node.getDataset());
        if (resolved == null || !resolved.getKind().equals("savedsearch")) {
            logger.warn("Failed to expand SavedsearchCommand: node={}", (Object)node);
            return node;
        }
        String searchstring = resolved.getProperties().getProperty("search").getString().get();
        try {
            parsed = new CompleteSPLParser().parse(searchstring);
        }
        catch (SPLParseException spe) {
            logger.warn("Failed to parse SavedsearchCommand: searchstring={}", (Object)searchstring);
            return node;
        }
        return parsed.accept(this);
    }

    @Override
    public CommandNode visit(JoinCommand node) {
        CommandNode[] newSources = new CommandNode[node.getSources().length];
        for (int i = 0; i < node.getSources().length; ++i) {
            newSources[i] = node.getSources()[i].accept(this);
        }
        JoinCommand joinNode = (JoinCommand)node.setSources(newSources);
        return joinNode.downgradeToV1();
    }

    @Override
    public CommandNode visit(StatsCommand node) {
        CommandNode newSource = node.getSource().accept(this);
        IGroupBy[] byFields = node.getByFields().toArray(new IGroupBy[0]);
        Boolean createdBinNode = false;
        if (byFields != null && byFields.length > 0) {
            for (int i = byFields.length - 1; i >= 0; --i) {
                if (!(byFields[i] instanceof BinNode)) continue;
                BinNode timeSpanNode = (BinNode)byFields[i];
                if (!createdBinNode.booleanValue()) {
                    createdBinNode = true;
                    newSource = new BinCommand(newSource, timeSpanNode);
                }
                byFields[i] = timeSpanNode.getField();
            }
        }
        return new StatsCommand(newSource, node.getAggregates(), Arrays.asList(byFields), node.getPartitions(), node.getAllnum(), node.getDelim(), node.isPrestatsMode());
    }
}

