/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.mgmt;

import com.splunk.commons.search.HostPort;
import com.splunk.df.mgmt.MonitoringSocketListener;
import com.splunk.df.search.SplunkEvent;
import com.splunk.df.util.Utils;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;

@Deprecated
public class DfmDriver {
    static Logger logger = Logger.getLogger(FindPortsFunction.class);

    public JavaRDD<HostPort> launchMonitoringNodes(JavaSparkContext sc, int startPort, int endPort, int numNodes) {
        ArrayList<String> dummies = new ArrayList<String>();
        for (int i = 0; i < numNodes; ++i) {
            dummies.add("monitoring node " + i);
        }
        JavaRDD dummyRdd = sc.parallelize(dummies, dummies.size());
        JavaRDD monitoringNodes = dummyRdd.map((Function)new FindPortsFunction(startPort, endPort));
        return monitoringNodes;
    }

    public JavaSparkContext createContext() {
        SparkConf conf = new SparkConf().setAppName("Splunk DFM Service");
        conf.registerKryoClasses(new Class[]{SplunkEvent.class});
        JavaSparkContext jsc = new JavaSparkContext(conf);
        return jsc;
    }

    static class FindPortsFunction
    implements Function<String, HostPort> {
        int startPort;
        int endPort;

        public FindPortsFunction(int startPort, int endPort) {
            this.startPort = startPort;
            this.endPort = endPort;
        }

        public HostPort call(String dummy) throws Exception {
            String host = Utils.getIpFromSplunkHostnameEnv();
            int boundPort = -1;
            for (int port = this.startPort; port < this.endPort; ++port) {
                try {
                    ServerSocket ss = new ServerSocket(port);
                    logger.info((Object)("Successfully bound to port: " + port));
                    MonitoringSocketListener listener = new MonitoringSocketListener(ss);
                    logger.info((Object)"Created listener");
                    listener.launch();
                    logger.info((Object)"Listenting...");
                    boundPort = port;
                    break;
                }
                catch (IOException ie) {
                    logger.error((Object)("Could not bind to port: " + port));
                    continue;
                }
            }
            return new HostPort(host, boundPort);
        }
    }
}

