/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search;

import java.util.HashSet;

public class DFSSupportedProcessors {
    private static DFSSupportedProcessors instance;
    private HashSet<String> supportedProcessors = new HashSet();

    private DFSSupportedProcessors() {
        this.loadProcessors();
    }

    private void loadProcessors() {
        this.supportedProcessors.add("stats");
        this.supportedProcessors.add("join");
        this.supportedProcessors.add("sort");
        this.supportedProcessors.add("head");
        this.supportedProcessors.add("tail");
        this.supportedProcessors.add("filter");
        this.supportedProcessors.add("eval");
        this.supportedProcessors.add("fields");
        this.supportedProcessors.add("dedup");
        this.supportedProcessors.add("union");
        this.supportedProcessors.add("rename");
        this.supportedProcessors.add("where");
        this.supportedProcessors.add("reverse");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized DFSSupportedProcessors getInstance() {
        if (instance != null) return instance;
        Class<DFSSupportedProcessors> clazz = DFSSupportedProcessors.class;
        synchronized (DFSSupportedProcessors.class) {
            if (instance != null) return instance;
            instance = new DFSSupportedProcessors();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public boolean isProcessorSupported(String processorName) {
        return this.supportedProcessors.contains(processorName);
    }
}

