/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search;

import com.splunk.df.search.compute.SearchResultFactory;
import com.splunk.df.util.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class FederatedDataSetInfo
implements Serializable {
    static final Logger logger = Logger.getLogger(FederatedDataSetInfo.class);
    private final String datasetName;
    private final String deploymentName;
    private final String search;
    private final int id;
    private int numFields;
    private String expandedSearch;
    private String searchExpandToAST;
    private String searchForEstimation;
    private String error;
    private long estimatedEventCount;
    private ArrayList<String> columnOrder;
    private int headN;
    private String headNSearch;

    public String getDatasetName() {
        return this.datasetName;
    }

    public String getDeploymentName() {
        return this.deploymentName;
    }

    public String getSearch() {
        return this.search;
    }

    public String getSearch(boolean headN) {
        return !headN || this.headNSearch.isEmpty() ? this.getSearch() : this.headNSearch;
    }

    public Long getEstimatedEventCount() {
        return this.estimatedEventCount;
    }

    public void setEstimatedEventCount(Long count) {
        this.estimatedEventCount = count;
    }

    public int getNumFields() {
        return this.numFields;
    }

    public void setNumFields(int numFields) {
        this.numFields = numFields;
    }

    public void setSearchExpanedToAST(String search) {
        this.searchExpandToAST = search;
    }

    public String getSearchExpandToAST() {
        return this.searchExpandToAST;
    }

    public String toString() {
        return String.format("DatasetName=%s\nDeploymentName=%s\nsearch=%s\nid=%d\nnumFields=%d\nexpandedSearch=%s\nsearchExpandedToAst=%s\nsearchForEstimation=%s\nError=%s\nEstimatedEventCount=%d\ncolumnOrder=%s\nheadN=%d\nheadNSearch=%s\n", this.datasetName, this.deploymentName, this.search, this.id, this.numFields, this.expandedSearch == null ? "null" : this.expandedSearch, this.searchExpandToAST == null ? "null" : this.searchExpandToAST, this.searchForEstimation == null ? "null:" : this.searchForEstimation, this.error == null ? "null" : this.error, this.estimatedEventCount, this.columnOrder == null ? "null" : "valid column order", this.headN, this.headNSearch == null ? "null" : this.headNSearch);
    }

    public String getExpandedSearch() {
        return this.expandedSearch;
    }

    public void setExpandedSearch(String expandedSearch) {
        this.expandedSearch = expandedSearch;
    }

    public FederatedDataSetInfo(String datasetName, String search, String deploymentName, int id) {
        this.datasetName = datasetName;
        this.search = search;
        this.deploymentName = deploymentName;
        this.estimatedEventCount = 0L;
        this.numFields = 0;
        this.id = id;
        this.error = "";
        this.headNSearch = "";
        this.headN = 0;
    }

    public FederatedDataSetInfo(String datasetName, String deploymentName, String search, int id, Integer numFields, String expandedSearch, String searchExpandToAST, String searchForEstimation, String error, Long estimatedEventCount, ArrayList<String> columnOrder, int headN, String headNSearch) {
        this.datasetName = datasetName;
        this.search = search;
        this.expandedSearch = expandedSearch;
        this.searchExpandToAST = searchExpandToAST;
        this.searchForEstimation = searchForEstimation;
        this.deploymentName = deploymentName;
        this.estimatedEventCount = estimatedEventCount;
        this.numFields = numFields;
        this.id = id;
        this.error = error;
        this.columnOrder = columnOrder;
        this.headNSearch = headNSearch;
        this.headN = headN;
    }

    public String getSearchForEstimation() {
        return this.searchForEstimation;
    }

    public void setSearchForEstimation(String searchForEstimation) {
        this.searchForEstimation = searchForEstimation;
    }

    public int getId() {
        return this.id;
    }

    public String getError() {
        return this.error;
    }

    public void setError(String error) {
        this.error = error;
    }

    public Boolean hasError() {
        return !this.error.equals("");
    }

    public ArrayList<String> getColumnOrder() {
        return this.columnOrder;
    }

    public void setColumnOrder(ArrayList<String> columnOrder) {
        this.columnOrder = columnOrder;
    }

    public int getHeadN() {
        return this.headN;
    }

    public void setHeadN(int headN) {
        this.headN = headN;
    }

    public void setHeadNSearch(String headNSearch) {
        this.headNSearch = headNSearch;
    }

    public static void write(OutputStream os, FederatedDataSetInfo dataSetInfo) throws IOException {
        Utils.write(os, dataSetInfo.datasetName);
        Utils.write(os, dataSetInfo.deploymentName);
        Utils.write(os, dataSetInfo.search);
        Utils.write(os, dataSetInfo.id);
        Utils.write(os, dataSetInfo.numFields);
        if (dataSetInfo.expandedSearch == null) {
            Utils.write(os, 1);
            SearchResultFactory.writeNullValue(os);
        } else {
            Utils.write(os, 0);
            Utils.write(os, dataSetInfo.expandedSearch);
        }
        if (dataSetInfo.searchExpandToAST == null) {
            Utils.write(os, 1);
            logger.info((Object)"This is the null case for searchExpandToAST");
            SearchResultFactory.writeNullValue(os);
        } else {
            Utils.write(os, 0);
            logger.info((Object)("In Write calling Utils.Write the value==>" + dataSetInfo.searchExpandToAST));
            Utils.write(os, dataSetInfo.searchExpandToAST);
        }
        if (dataSetInfo.searchForEstimation == null) {
            Utils.write(os, 1);
            SearchResultFactory.writeNullValue(os);
        } else {
            Utils.write(os, 0);
            Utils.write(os, dataSetInfo.searchForEstimation);
        }
        Utils.write(os, dataSetInfo.error);
        Utils.write(os, dataSetInfo.estimatedEventCount);
        if (dataSetInfo.columnOrder == null) {
            Utils.write(os, 1);
            SearchResultFactory.writeNullValue(os);
        } else {
            SearchResultFactory.writeArrayList(os, dataSetInfo.columnOrder);
        }
        Utils.write(os, dataSetInfo.headN);
        Utils.write(os, dataSetInfo.headNSearch);
    }

    public static FederatedDataSetInfo read(InputStream is) throws IOException {
        String dsSearchExpandToAst;
        String dsdataSetName = Utils.readString(is);
        String dsdeploymentName = Utils.readString(is);
        String dsSearch = Utils.readString(is);
        int dsID = Utils.readInt(is);
        int dsNumFields = Utils.readInt(is);
        int isNull = Utils.readInt(is);
        String dsExpandedSearch = isNull == 1 ? null : Utils.readString(is);
        isNull = Utils.readInt(is);
        if (isNull == 1) {
            logger.debug((Object)"The null marker is ON");
            dsSearchExpandToAst = null;
        } else {
            dsSearchExpandToAst = Utils.readString(is);
            logger.debug((Object)("This is non null -->" + dsSearchExpandToAst));
        }
        isNull = Utils.readInt(is);
        String dsSearchForEstimation = isNull == 1 ? null : Utils.readString(is);
        String dsError = Utils.readString(is);
        long dsEstimatedEventCount = Utils.readLong(is);
        isNull = Utils.readInt(is);
        ArrayList dsColumnOrder = isNull == 1 ? null : SearchResultFactory.readArrayList(is);
        int dsHeadN = Utils.readInt(is);
        String dsHeadNSearch = Utils.readString(is);
        return new FederatedDataSetInfo(dsdataSetName, dsdeploymentName, dsSearch, dsID, dsNumFields, dsExpandedSearch, dsSearchExpandToAst, dsSearchForEstimation, dsError, dsEstimatedEventCount, dsColumnOrder, dsHeadN, dsHeadNSearch);
    }
}

