/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search;

import com.splunk.df.util.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;

public class SplunkReleaseVersion
implements Serializable,
Comparable<SplunkReleaseVersion> {
    private int major;
    private int minor;
    private int maint;
    public static final SplunkReleaseVersion INVALID = new SplunkReleaseVersion(0, 0, 0);
    public static final SplunkReleaseVersion MADONNA = new SplunkReleaseVersion(4, 0);
    public static final SplunkReleaseVersion PRINCE = new SplunkReleaseVersion(4, 1);
    public static final SplunkReleaseVersion V4_1_1 = new SplunkReleaseVersion(4, 1, 1);
    public static final SplunkReleaseVersion HAMMER = new SplunkReleaseVersion(4, 2);
    public static final SplunkReleaseVersion V4_2_3 = new SplunkReleaseVersion(4, 2, 3);
    public static final SplunkReleaseVersion BIEBER = new SplunkReleaseVersion(4, 3);
    public static final SplunkReleaseVersion ACE = new SplunkReleaseVersion(5, 0);
    public static final SplunkReleaseVersion BUBBLES = new SplunkReleaseVersion(6, 0);
    public static final SplunkReleaseVersion CUPCAKE = new SplunkReleaseVersion(6, 1);
    public static final SplunkReleaseVersion DASH = new SplunkReleaseVersion(6, 2);
    public static final SplunkReleaseVersion EMBER = new SplunkReleaseVersion(6, 3);
    public static final SplunkReleaseVersion FLUTTERSHY = new SplunkReleaseVersion(6, 3, 1511);
    public static final SplunkReleaseVersion GALAXY = new SplunkReleaseVersion(6, 4);
    public static final SplunkReleaseVersion HONEYBUZZ = new SplunkReleaseVersion(6, 4, 1606);
    public static final SplunkReleaseVersion IVORY = new SplunkReleaseVersion(6, 5);
    public static final SplunkReleaseVersion JACKHAMMER = new SplunkReleaseVersion(6, 5, 1612);
    public static final SplunkReleaseVersion KIMONO = new SplunkReleaseVersion(6, 6);
    public static final SplunkReleaseVersion MINTY = new SplunkReleaseVersion(7, 0);
    public static final SplunkReleaseVersion NIGHTLIGHT = new SplunkReleaseVersion(7, 1);
    public static final SplunkReleaseVersion ORANGESWIRL = new SplunkReleaseVersion(7, 2);
    public static final SplunkReleaseVersion PINKIEPIE = new SplunkReleaseVersion(7, 3);
    public static final SplunkReleaseVersion QUAKE = new SplunkReleaseVersion(8, 0);

    public SplunkReleaseVersion(String versionStr) {
        if (versionStr == null || versionStr.trim().equals("")) {
            throw new RuntimeException("Invalid splunk version:" + versionStr);
        }
        String[] parts = versionStr.trim().split("\\.");
        if (parts.length >= 1) {
            this.major = Integer.parseInt(parts[0]);
        }
        if (parts.length >= 2) {
            this.minor = Integer.parseInt(parts[1]);
        }
        if (parts.length >= 3) {
            this.maint = Integer.parseInt(parts[2]);
        }
    }

    public SplunkReleaseVersion(int major, int minor, int maint) {
        this.major = major;
        this.minor = minor;
        this.maint = maint;
    }

    public SplunkReleaseVersion(int major, int minor) {
        this.major = major;
        this.minor = minor;
        this.maint = 0;
    }

    public boolean isValid() {
        return this.major != 0;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.maint;
        result = 31 * result + this.major;
        result = 31 * result + this.minor;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SplunkReleaseVersion other = (SplunkReleaseVersion)obj;
        if (this.maint != other.maint) {
            return false;
        }
        if (this.major != other.major) {
            return false;
        }
        return this.minor == other.minor;
    }

    @Override
    public int compareTo(SplunkReleaseVersion other) {
        if (this.major != other.major) {
            if (!this.isValid()) {
                return -1;
            }
            if (!other.isValid()) {
                return 1;
            }
            return this.major - other.major;
        }
        if (this.minor != other.minor) {
            return this.minor - other.minor;
        }
        return this.maint - other.maint;
    }

    public String toString() {
        return "[splunk version: " + this.major + "." + this.minor + "." + this.maint + "]";
    }

    public static void write(OutputStream os, SplunkReleaseVersion splunkReleaseVersion) throws IOException {
        Utils.write(os, splunkReleaseVersion.major);
        Utils.write(os, splunkReleaseVersion.minor);
        Utils.write(os, splunkReleaseVersion.maint);
    }

    public static SplunkReleaseVersion read(InputStream is) throws IOException {
        int deserMajor = Utils.readInt(is);
        int deserMinor = Utils.readInt(is);
        int deserMain = Utils.readInt(is);
        return new SplunkReleaseVersion(deserMajor, deserMinor, deserMain);
    }
}

