/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search.compute.transformers;

import com.splunk.commons.Row;
import com.splunk.commons.ast.nodes.CommandNode;
import com.splunk.commons.ast.nodes.IOrdering;
import com.splunk.commons.ast.nodes.IWherePredicate;
import com.splunk.commons.ast.nodes.Node;
import com.splunk.commons.ast.nodes.commands.HeadCommand;
import com.splunk.commons.ast.nodes.expressions.FieldType;
import com.splunk.commons.ast.nodes.expressions.SortNode;
import com.splunk.commons.ast.nodes.expressions.SortOrder;
import com.splunk.commons.visitors.ExpressionEvaluator;
import com.splunk.df.search.compute.ComputeEngineContext;
import com.splunk.df.search.compute.DistributedDataset;
import com.splunk.df.search.compute.MapPartitioner;
import com.splunk.df.search.compute.SearchResult;
import com.splunk.df.search.compute.SearchResultFactory;
import com.splunk.df.search.compute.Transformer;
import com.splunk.df.search.compute.TransformerRegistry;
import com.splunk.df.search.compute.transformers.BaseTransformerFactory;
import com.splunk.df.search.compute.transformers.FieldExtractor;
import com.splunk.df.search.compute.transformers.SortTransformer;
import com.splunk.df.util.Utils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.log4j.Logger;

public class HeadTransformer
implements Transformer {
    static final Logger logger = Logger.getLogger(HeadTransformer.class);

    @Override
    public DistributedDataset transform(DistributedDataset dd, CommandNode qcmd, boolean streaming, ComputeEngineContext ctx) {
        return HeadTransformer._transform(ctx, dd, (HeadCommand)qcmd, streaming);
    }

    private static DistributedDataset applyName(DistributedDataset dataset) {
        dataset.setName(HeadTransformer.class.getName());
        return dataset;
    }

    private static DistributedDataset _transform(ComputeEngineContext ctx, DistributedDataset dd, HeadCommand headCmd, boolean streaming) {
        boolean executeExternal;
        long limit = Long.parseLong(headCmd.getLimit().toString());
        if (limit < 0L) {
            throw new IllegalArgumentException(String.format("Limit value needs to be a positive number", new Object[0]));
        }
        long maxLimit = Utils.getMaxLimitRecords();
        if (limit > maxLimit) {
            logger.warn((Object)String.format("limit: %d is greater than max allowed limit: %d, will be capped at max limit", limit, maxLimit));
        }
        final long finalLimit = limit = Math.min(maxLimit, limit);
        DistributedDataset outputdd = dd;
        CommandNode source = headCmd.getSource();
        boolean bl = executeExternal = !BaseTransformerFactory.getInstance().canExecuteExternal((CommandNode)headCmd, source);
        if (executeExternal) {
            outputdd = HeadTransformer.applyName(BaseTransformerFactory.getInstance().transform(outputdd, (CommandNode)headCmd, ctx));
            outputdd = HeadTransformer.applyName(outputdd.cacheDisk());
            logger.debug((Object)" will execute base transformer to input create dataset");
        } else {
            Transformer t = ((TransformerRegistry)ctx.get("dfs.dataset.transformer.registry")).getTransformer(source);
            if (t instanceof SortTransformer) {
                ctx.addContext("headImposedLimit", (int)limit);
                logger.info((Object)String.format("since the source is a sort transformer setting the head imposed limit to: %d", limit));
            }
            logger.debug((Object)String.format("Using source transformer - %s", source.getCommandName()));
            outputdd = HeadTransformer.applyName(t.transform(outputdd, source, streaming, ctx));
            ctx.removeContext("headImposedLimit");
        }
        IWherePredicate wherePredicate = headCmd.getPredicate();
        if (wherePredicate != null) {
            final Node predicateNode = wherePredicate.getNode();
            final boolean fillNull = headCmd.getNullIsMatch().getValue();
            final ExpressionEvaluator expressionEvaluator = new ExpressionEvaluator();
            MapPartitioner evalExpression = new MapPartitioner(){
                private static final long serialVersionUID = 1L;

                @Override
                public Iterator<SearchResult> mapPartitions(int partitionId, Iterator<SearchResult> iterator) {
                    LinkedList<SearchResult> fifo = new LinkedList<SearchResult>();
                    boolean stop = false;
                    while (iterator.hasNext()) {
                        Row row;
                        Object eval;
                        SearchResult searchResult = iterator.next();
                        if (stop || finalLimit != 0L && (long)fifo.size() >= finalLimit || !((eval = expressionEvaluator.evaluate(predicateNode, row = new Row(SearchResultFactory.convert(searchResult.getDataMap())), fillNull)) instanceof Boolean)) continue;
                        boolean evalResult = (Boolean)eval;
                        searchResult.setField(SearchResult.FieldMeta.newFieldMeta("__evalResult__"), evalResult);
                        fifo.add(searchResult);
                        if (evalResult) continue;
                        stop = true;
                    }
                    return fifo.iterator();
                }

                @Override
                public boolean repartition() {
                    return false;
                }

                @Override
                public FieldExtractor.ExtractionHint fieldExtractionHint() {
                    return FieldExtractor.ExtractionHint.NOT_PRECOMPUTED;
                }

                @Override
                public String desc() {
                    return "headTransformerWhereProcessing";
                }
            };
            outputdd = HeadTransformer.applyName(outputdd.transform(evalExpression));
            MapPartitioner extractDirtyPartitionIds = new MapPartitioner(){
                private static final long serialVersionUID = 1L;
                boolean stop = false;

                @Override
                public Iterator<SearchResult> mapPartitions(int partitionId, Iterator<SearchResult> iterator) {
                    LinkedList<SearchResult> fifo = new LinkedList<SearchResult>();
                    while (iterator.hasNext()) {
                        boolean evalResult;
                        Object eval;
                        SearchResult searchResult = iterator.next();
                        if (this.stop || !((eval = searchResult.getFieldValue(SearchResult.FieldMeta.newFieldMeta("__evalResult__"))) instanceof Boolean) || (evalResult = ((Boolean)eval).booleanValue())) continue;
                        SearchResult.FieldMeta[] fieldNames = new SearchResult.FieldMeta[]{SearchResult.FieldMeta.newFieldMeta("partition_id")};
                        Object[] fieldValues = new Object[]{partitionId};
                        SearchResult newSearchResult = SearchResultFactory.getInstance().createSearchResult(fieldNames, fieldValues);
                        fifo.add(newSearchResult);
                        this.stop = true;
                    }
                    return fifo.iterator();
                }

                @Override
                public boolean repartition() {
                    return false;
                }

                @Override
                public FieldExtractor.ExtractionHint fieldExtractionHint() {
                    return FieldExtractor.ExtractionHint.NOT_PRECOMPUTED;
                }

                @Override
                public String desc() {
                    return "headTransformerExtractDirtyParids";
                }
            };
            DistributedDataset ddWithDirtySplitIndex = HeadTransformer.applyName(outputdd.transform(extractDirtyPartitionIds));
            final int dirtyPartitionId = (ddWithDirtySplitIndex = HeadTransformer.applyName(ddWithDirtySplitIndex.sort(new IOrdering[]{new SortNode("partition_id", SortOrder.ASC, FieldType.NUM)}))).count() > 0L ? (Integer)ddWithDirtySplitIndex.retrieve(1).get(0).getFieldValue(SearchResult.FieldMeta.newFieldMeta("partition_id")) : -1;
            final Boolean keeplast = headCmd.getKeeplast().getValue();
            MapPartitioner extractByDirtyPartitionId = new MapPartitioner(){
                private static final long serialVersionUID = 1L;

                @Override
                public Iterator<SearchResult> mapPartitions(int partitionId, Iterator<SearchResult> iterator) {
                    if (dirtyPartitionId < 0) {
                        return iterator;
                    }
                    if (partitionId < dirtyPartitionId) {
                        return iterator;
                    }
                    if (partitionId > dirtyPartitionId) {
                        return new ArrayList().iterator();
                    }
                    LinkedList<SearchResult> fifo = new LinkedList<SearchResult>();
                    boolean stop = false;
                    while (iterator.hasNext()) {
                        Object eval;
                        SearchResult searchResult = iterator.next();
                        if (stop || !((eval = searchResult.getFieldValue(SearchResult.FieldMeta.newFieldMeta("__evalResult__"))) instanceof Boolean)) continue;
                        boolean evalResult = (Boolean)eval;
                        if (!evalResult) {
                            stop = true;
                            if (!keeplast.booleanValue()) continue;
                            fifo.add(searchResult);
                            continue;
                        }
                        fifo.add(searchResult);
                    }
                    return fifo.iterator();
                }

                @Override
                public boolean repartition() {
                    return false;
                }

                @Override
                public FieldExtractor.ExtractionHint fieldExtractionHint() {
                    return FieldExtractor.ExtractionHint.NOT_PRECOMPUTED;
                }

                @Override
                public String desc() {
                    return "headTransformerExtractDirtyParId";
                }
            };
            outputdd = HeadTransformer.applyName(outputdd.transform(extractByDirtyPartitionId));
            MapPartitioner removeEvaluationResult = new MapPartitioner(){
                private static final long serialVersionUID = 1L;

                @Override
                public Iterator<SearchResult> mapPartitions(int partitionId, Iterator<SearchResult> iterator) {
                    LinkedList<SearchResult> fifo = new LinkedList<SearchResult>();
                    while (iterator.hasNext()) {
                        SearchResult searchResult = iterator.next();
                        searchResult.unsetField(SearchResult.FieldMeta.newFieldMeta("__evalResult__"));
                        fifo.add(searchResult);
                    }
                    return fifo.iterator();
                }

                @Override
                public boolean repartition() {
                    return false;
                }

                @Override
                public FieldExtractor.ExtractionHint fieldExtractionHint() {
                    return FieldExtractor.ExtractionHint.NOT_PRECOMPUTED;
                }

                @Override
                public String desc() {
                    return "headTransformerRemoveEvalResult";
                }
            };
            outputdd = HeadTransformer.applyName(outputdd.transform(removeEvaluationResult));
        }
        if (limit > 0L) {
            outputdd = HeadTransformer.applyName(outputdd.limit(limit));
            logger.debug((Object)String.format("Limit set on dataset: %d", limit));
        }
        return outputdd;
    }

    @Override
    public String name() {
        return "HeadTransformer";
    }
}

