/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mr.cache;

import com.splunk.io.SearchMetricsReporter;
import com.splunk.io.SearchOutputStream;
import com.splunk.mr.SplunkMR;
import com.splunk.mr.cache.CacheIndex;
import com.splunk.mr.cache.CacheIndexer;
import com.splunk.mr.cache.CacheInfoFile;
import com.splunk.mr.cache.CacheMerger;
import com.splunk.mr.cache.CacheReference;
import com.splunk.mr.cache.CacheReport;
import com.splunk.mr.cache.CompactionMetadata;
import com.splunk.mr.cache.GetsReferenceFile;
import com.splunk.mr.cache.Hasher;
import com.splunk.mr.cache.JobQueue;
import com.splunk.mr.cache.JobQueueProcesser;
import com.splunk.mr.cache.PathAndPointer;
import com.splunk.mr.cache.integration.CacheKey;
import com.splunk.mr.cache.integration.CacheSplitListener;
import com.splunk.mr.cache.integration.KeyPointer;
import com.splunk.mr.cache.reader.CachePathsReader;
import com.splunk.mr.cache.reader.CachedResultProcessor;
import com.splunk.mr.cache.reader.GetsTransitionedPath;
import com.splunk.mr.cache.reader.ResultProcessorFactory;
import com.splunk.mr.cache.reporting.Report;
import com.splunk.util.Lazy;
import com.splunk.util.StrUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.MD5Hash;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.log4j.Logger;

public class MapCache {
    private static final Logger gLogger = Logger.getLogger(MapCache.class);
    public static final Date NEVER_EXPIRE = new Date(Long.MAX_VALUE);
    private final FileSystem fileSystem;
    private final Path cachePath;
    private final Hasher hasher;
    private final JobQueue jobQueue;
    private final CacheIndex cacheIndex;
    private final CachePathsReader cachePathsReader;
    private final PartialResultFetcher partialResultFetcher;
    private final CacheInfoFile cacheInfoFile;
    private volatile CachedResultProcessor fetchProcesser = null;
    private boolean hasEnsured = false;

    public MapCache(FileSystem fileSystem, Path cachePath, Hasher hasher, JobQueue jobQueue, CacheIndex cacheIndex, CachePathsReader cachePathsReader, PartialResultFetcher partialResultFetcher, CacheInfoFile cacheInfoFile) {
        this.fileSystem = fileSystem;
        this.cachePath = cachePath;
        this.hasher = hasher;
        this.jobQueue = jobQueue;
        this.cacheIndex = cacheIndex;
        this.cachePathsReader = cachePathsReader;
        this.partialResultFetcher = partialResultFetcher;
        this.cacheInfoFile = cacheInfoFile;
    }

    public FileSystem getFileSystem() {
        return this.fileSystem;
    }

    public Path getCachePath() {
        return this.cachePath;
    }

    public boolean hasCompactedResult(CacheKey key) {
        MD5Hash hash = this.hashKey(key);
        return this.cachePathsReader.readCachePaths().containsKey(hash);
    }

    public boolean hasStagedResult(CacheKey key) {
        MD5Hash hash = this.hashKey(key);
        try {
            return this.jobQueue.hasResult(hash, true);
        }
        catch (IOException e) {
            return false;
        }
    }

    public PathAndPointer getCompactedPathAndPointer(CacheKey key) {
        MD5Hash hash;
        Map<MD5Hash, PathAndPointer> cachePaths = this.cachePathsReader.readCachePaths();
        if (cachePaths.containsKey(hash = this.hashKey(key))) {
            return cachePaths.get(hash);
        }
        throw new IllegalStateException("Cache did not contain key: " + key + ", hash: " + hash);
    }

    public void writeResult(CacheKey key, Path resultFile) throws IOException {
        this.jobQueue.put(this.hashKey(key), resultFile, key.getSplitMetadata());
    }

    public void writeResult(CacheKey key, InputStream results) throws IOException {
        MD5Hash hash = this.hashKey(key);
        this.jobQueue.put(hash, results, key.getSplitMetadata());
    }

    public static MapCache create(FileSystem fs, Path cachePath) {
        Path queueDir = MapCache.getQueueDir(cachePath);
        if (SplunkMR.IS_SEARCH_HEAD && SplunkMR.isCachePopulationSearch(fs.getConf())) {
            MapCache.setupQueueDir(fs, queueDir);
        }
        CacheReference cacheRef = MapCache.getCacheReference(fs, cachePath);
        gLogger.debug((Object)("Creating MapCache with cache dir: " + cachePath));
        CachePathsReader cachePathsReader = CachePathsReader.create(fs, cacheRef);
        return new MapCache(fs, cachePath, MapCache.createHasher(), new JobQueue(fs, queueDir), CacheIndex.create(fs, cacheRef, cachePathsReader), cachePathsReader, new PartialResultFetcher(fs, cacheRef), new CacheInfoFile(fs));
    }

    private static void setupQueueDir(FileSystem fs, Path queueDir) {
        UserGroupInformation currentUser = MapCache.getCurrentUser();
        try {
            boolean made = fs.mkdirs(queueDir, new FsPermission(457));
            if (!made && !fs.exists(queueDir)) {
                throw new IOException("Could not create queueDir: " + queueDir);
            }
            if (SplunkMR.useProxy(fs.getConf())) {
                MapCache.changeOwnerForImpersonation(fs, queueDir, currentUser);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not setup queue dir for impersonation: " + e);
        }
    }

    private static void changeOwnerForImpersonation(FileSystem fs, Path queueDir, UserGroupInformation currentUser) throws IOException {
        FileStatus fileStatus = fs.getFileStatus(queueDir);
        String userName = currentUser.getUserName();
        if (gLogger.isDebugEnabled()) {
            gLogger.debug((Object)("User: " + UserGroupInformation.getCurrentUser().getUserName() + ", setting username: " + userName + ", to queueDir: " + queueDir));
        }
        fs.setOwner(queueDir, userName, fileStatus.getGroup());
    }

    private static UserGroupInformation getCurrentUser() {
        try {
            return UserGroupInformation.getCurrentUser();
        }
        catch (IOException e) {
            throw new RuntimeException("Could not get user.", e);
        }
    }

    private static Hasher createHasher() {
        return new Hasher();
    }

    public static CacheReference getCacheReference(FileSystem fs, Path cacheDir) {
        Path referenceDir = new Path(cacheDir, "refs");
        return new CacheReference(fs, new GetsReferenceFile(fs, referenceDir), referenceDir);
    }

    public static void compactCache(FileSystem fs, Path cacheDir) throws IOException {
        try {
            MapCache.processJobQueue(fs, cacheDir);
        }
        catch (Exception e) {
            gLogger.debug((Object)("Got exception when processing job queue: " + e + ". Probably because someone else tried to proces the job queue at the same time. If so, it's expected to happen."));
        }
        try {
            MapCache.mergeCache(fs, cacheDir);
        }
        catch (Exception e) {
            gLogger.debug((Object)("Got exception when processing merging cache: " + e));
        }
    }

    public static void processJobQueue(FileSystem fs, Path cacheDir) throws IOException {
        MapCache.processJobQueue(fs, cacheDir, Integer.MAX_VALUE, null);
    }

    public static int processJobQueue(FileSystem fs, Path cacheDir, int limit, SearchMetricsReporter metrics) throws IOException {
        Path queueDir = MapCache.getQueueDir(cacheDir);
        Path compactsDir = MapCache.getCompactsDir(cacheDir);
        CacheReference cacheReference = MapCache.getCacheReference(fs, cacheDir);
        return MapCache.processJobWithinCacheDir(fs, queueDir, compactsDir, cacheReference, limit, metrics);
    }

    public static int mergeCache(FileSystem fs, Path cacheDir) throws IOException {
        return MapCache.mergeCache(fs, cacheDir, MapCache.getCacheReference(fs, cacheDir));
    }

    private static int processJobWithinCacheDir(FileSystem fs, Path queueDir, Path compactsDir, CacheReference cacheReference, int limit, SearchMetricsReporter metrics) throws IOException {
        CacheIndexer cacheIndexer = new CacheIndexer(fs, MapCache.getUniquePath(compactsDir), cacheReference);
        JobQueue jobQueue = new JobQueue(fs, queueDir, metrics);
        return new JobQueueProcesser(jobQueue, cacheIndexer, new JobQueueProcesser.CacheJobDeleter(fs)).indexJobQueue(limit);
    }

    private static int mergeCache(FileSystem fs, Path cacheDir, CacheReference cacheReference) throws IOException {
        return new CacheMerger(fs, cacheReference, fs.getConf(), MapCache.getCompactsDir(cacheDir), MapCache.getStablesDir(cacheDir)).merge();
    }

    public static Path getUniquePath(Path parent) {
        return new Path(parent, UUID.randomUUID().toString());
    }

    public static Path getStablesDir(Path cacheDir) {
        return new Path(cacheDir, "stables");
    }

    public static Path getCompactsDir(Path cacheDir) {
        return new Path(cacheDir, "compacts");
    }

    public static Path getQueueDir(Path cacheDir) {
        return MapCache.getQueueDirWithUser(new Path(cacheDir, "tmp"));
    }

    private static Path getQueueDirWithUser(Path queueRoot) {
        try {
            String userName = UserGroupInformation.getCurrentUser().getShortUserName();
            gLogger.debug((Object)("Will use queue dir with user name: " + userName));
            if (!StrUtil.isAlphanumeric(userName)) {
                userName = MD5Hash.digest((String)userName).toString();
                gLogger.debug((Object)("User name was not alphanumeric. Using hashed username: " + userName));
            }
            Path queueDir = new Path(queueRoot, "user/" + userName);
            gLogger.debug((Object)("Using cache queue dir: " + queueDir));
            return queueDir;
        }
        catch (IOException e) {
            throw new RuntimeException("Could not get cache jobs dir with user information", e);
        }
    }

    public static MD5Hash getCompactedHashForCacheKey(Object cacheKey) {
        return Hasher.invoke(cacheKey.toString());
    }

    public static MD5Hash getStagedHashForCacheKey(String cacheKey) {
        return Hasher.invoke(cacheKey);
    }

    public JobQueue.CacheJob getStagedResult(CacheKey key) throws IOException {
        return this.jobQueue.getQueuedResult(this.hashKey(key));
    }

    private MD5Hash hashKey(CacheKey key) {
        return this.hasher.hash(key.getSplitSearchId());
    }

    public void fetchCompactedResult(CacheKey cacheKey, SearchOutputStream out, ThreadPoolExecutor threadPool, CacheSplitListener cacheSplitListener) {
        CachedResultProcessor fetcher = this.getResultFetcher(out, threadPool, cacheSplitListener);
        PathAndPointer pnp = this.getCompactedPathAndPointer(cacheKey);
        fetcher.offer(new KeyPointer(cacheKey, pnp));
    }

    private synchronized CachedResultProcessor getResultFetcher(SearchOutputStream out, ThreadPoolExecutor threadPool, CacheSplitListener cacheSplitListener) {
        if (this.fetchProcesser == null) {
            this.fetchProcesser = this.partialResultFetcher.getNew(out, threadPool, cacheSplitListener);
        }
        return this.fetchProcesser;
    }

    public void awaitResultFetcher() {
        if (this.fetchProcesser != null) {
            this.fetchProcesser.awaitCompletion();
        }
    }

    public synchronized void flagCacheUpdate() {
        this.cachePathsReader.updateCacheRef();
        this.jobQueue.clearCache();
    }

    @Deprecated
    Lazy<InputStream> getResult(CacheKey key) {
        MD5Hash hash = this.hashKey(key);
        Lazy<InputStream> indexResult = this.getIndexedResult(hash);
        if (indexResult != null) {
            return indexResult;
        }
        Lazy<InputStream> queuedResult = this.getQueuedResult(hash);
        if (queuedResult != null) {
            return queuedResult;
        }
        return null;
    }

    private Lazy<InputStream> getIndexedResult(MD5Hash hash) {
        try {
            return this.cacheIndex.getResult(hash);
        }
        catch (IOException e) {
            gLogger.info((Object)("Got exception: " + e.getMessage()));
            return null;
        }
    }

    private Lazy<InputStream> getQueuedResult(MD5Hash hash) {
        try {
            JobQueue.CacheJob queuedResult = this.jobQueue.getQueuedResult(hash);
            if (queuedResult != null) {
                return queuedResult.lazyResults;
            }
        }
        catch (IOException e) {
            gLogger.info((Object)("Got exception: " + e.getMessage()));
        }
        return null;
    }

    public int processJobQueue(int limit, SearchMetricsReporter metrics) throws IOException {
        return MapCache.processJobQueue(this.fileSystem, this.cachePath, limit, metrics);
    }

    public int mergeCache() throws IOException {
        return MapCache.mergeCache(this.fileSystem, this.cachePath);
    }

    public void setReadKeysPool(ExecutorService threadPool) {
        this.cachePathsReader.setThreadPool(threadPool);
    }

    public void ensureCacheInfoFile(CacheKey cacheKey) throws IOException {
        if (!this.hasEnsured) {
            try {
                if (!this.cacheInfoFile.exists()) {
                    this.cacheInfoFile.create(this.getCacheInfo(cacheKey));
                }
            }
            finally {
                this.hasEnsured = true;
            }
        }
    }

    private Map<String, String> getCacheInfo(CacheKey cacheKey) {
        HashMap<String, String> kvs = new HashMap<String, String>();
        Configuration conf = this.fileSystem.getConf();
        kvs.put("index", cacheKey.getIndex());
        kvs.put("search", conf.get(SplunkMR.CONF_SEARCH_MAP));
        kvs.put("summary_id", cacheKey.getSummaryId());
        return kvs;
    }

    public void setCacheInfoDir(Path cacheInfoDir) {
        this.cacheInfoFile.withDir(cacheInfoDir);
    }

    public static Date getCompactionLatestTime(FileSystem fs, Path compactionPath) throws IOException, CompactionMetadata.CompactionLtNotFoundException {
        return CompactionMetadata.getCompactionLatestTime(fs, compactionPath);
    }

    public void probe(Report report) throws IOException {
        CacheReport.fillReport(this, report);
    }

    public static class PartialResultFetcher {
        private final FileSystem fs;
        private final CacheReference cacheRef;

        public PartialResultFetcher(FileSystem fs, CacheReference cacheRef) {
            this.fs = fs;
            this.cacheRef = cacheRef;
        }

        public CachedResultProcessor getNew(SearchOutputStream out, ThreadPoolExecutor threadPool, CacheSplitListener cacheSplitListener) {
            return new CachedResultProcessor(new ResultProcessorFactory(this.fs, new GetsTransitionedPath(this.cacheRef), out, cacheSplitListener), (ExecutorService)threadPool);
        }
    }
}

